/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.trie;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.predict4all.nlp.ngram.trie.AbstractNGramTrieNode;
import org.predict4all.nlp.ngram.trie.map.TrieNodeMap;

public class StaticNGramTrieNode
extends AbstractNGramTrieNode<StaticNGramTrieNode> {
    private int childrenSize;

    public StaticNGramTrieNode getNodeFor(FileChannel fileChannel, int[] prefix, int index) throws IOException {
        if (index < prefix.length) {
            StaticNGramTrieNode child;
            int wordId = prefix[index];
            if (this.checkChildrenLoading(fileChannel) && (child = (StaticNGramTrieNode)this.children.get(wordId)) != null) {
                return child.getNodeFor(fileChannel, prefix, index + 1);
            }
            return null;
        }
        return this;
    }

    public boolean checkChildrenLoading(FileChannel fileChannel) throws IOException {
        if (this.childrenPosition >= 0 && this.children == null) {
            this.children = new TrieNodeMap();
            this.readChildren(fileChannel);
            this.children.compact();
            return true;
        }
        return this.children != null;
    }

    private void readChildren(FileChannel fileChannel) throws IOException {
        ByteBuffer buffWrite = ByteBuffer.allocate(this.childrenSize * 28);
        fileChannel.read(buffWrite, this.childrenPosition);
        ((Buffer)buffWrite).flip();
        for (int i = 0; i < this.childrenSize; ++i) {
            StaticNGramTrieNode trieNode = new StaticNGramTrieNode();
            int wordId = trieNode.readNodeInformation(buffWrite);
            this.children.put(wordId, trieNode);
        }
    }

    public int readNodeInformation(ByteBuffer buffWrite) {
        int wordId = buffWrite.getInt();
        this.childrenSize = buffWrite.getInt();
        this.childrenPosition = buffWrite.getInt();
        this.frequency = buffWrite.getDouble();
        this.childrenBackoffWeight = buffWrite.getDouble();
        return wordId;
    }

    @Override
    public int getChildrenSize() {
        return this.childrenSize;
    }
}

