/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.trie.map;

import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.PrimeFinder;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class TrieNodeMap<V> {
    public static final byte FREE = 0;
    public static final byte FULL = 1;
    public static final byte REMOVED = 2;
    protected transient int _size;
    protected transient int _free;
    public transient int[] _set;
    protected boolean consumeFreeSlot;
    protected int _maxSize;
    public transient byte[] _states;
    protected transient V[] _values;
    public static int oneInstanceCount = 0;

    public TrieNodeMap() {
        this.setUp(HashFunctions.fastCeil((float)10.0f));
        this.setUp(HashFunctions.fastCeil((float)10.0f));
        Arrays.fill(this._set, -1);
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public int size() {
        return this._size;
    }

    public void compact() {
        if (this._maxSize > this._size + 1) {
            this.rehash(PrimeFinder.nextPrime((int)Math.max(this._size + 1, HashFunctions.fastCeil((float)((float)this.size() / 1.0f)) + 1)));
            this.computeMaxSize(this.capacity());
        }
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index) {
        this._values[index] = null;
        this._set[index] = -1;
        this._states[index] = 2;
        --this._size;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
        Arrays.fill(this._set, 0, this._set.length, -1);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime((int)initialCapacity);
        this.computeMaxSize(capacity);
        this._states = new byte[capacity];
        this._set = new int[capacity];
        this._values = new Object[capacity];
        return capacity;
    }

    protected void computeMaxSize(int capacity) {
        this._free = capacity - this._size;
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * 1.0f));
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int newCapacity = this._size > this._maxSize ? PrimeFinder.nextPrime((int)(this.capacity() << 1)) : this.capacity();
            this.rehash(newCapacity);
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }

    public int capacity() {
        return this._states.length;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected int index(int val) {
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash((int)val) & Integer.MAX_VALUE;
        int index = hash % length;
        byte state = states[index];
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set[index] == val) {
            return index;
        }
        return this.indexRehashed(val, index, hash, state);
    }

    int indexRehashed(int key, int index, int hash, byte state) {
        int length = this._set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states[index]) == 0) {
                return -1;
            }
            if (key != this._set[index] || state == 2) continue;
            return index;
        } while (index != loopIndex);
        return -1;
    }

    protected int insertKey(int val) {
        int hash = HashFunctions.hash((int)val) & Integer.MAX_VALUE;
        int index = hash % this._states.length;
        byte state = this._states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index, val);
            return index;
        }
        if (state == 1 && this._set[index] == val) {
            return -index - 1;
        }
        return this.insertKeyRehash(val, index, hash, state);
    }

    int insertKeyRehash(int val, int index, int hash, byte state) {
        int length = this._set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index;
            }
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states[index]) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index, val);
                return index;
            }
            if (state != 1 || this._set[index] != val) continue;
            return -index - 1;
        } while (index != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index, int val) {
        this._set[index] = val;
        this._states[index] = 1;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        V[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index = this.insertKey(o);
            this._values[index] = oldVals[i];
        }
    }

    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public boolean containsValue(Object val) {
        byte[] states = this._states;
        V[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || null != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public V get(int key) {
        int index = this.index(key);
        return index < 0 ? null : (V)this._values[index];
    }

    public V put(int key, V value) {
        int index = this.insertKey(key);
        return this.doPut(value, index);
    }

    public V putIfAbsent(int key, V value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(value, index);
    }

    private V doPut(V value, int index) {
        V previous = null;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    public V remove(int key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public void putAll(Map<? extends Integer, ? extends V> map) {
        Set<Map.Entry<Integer, V>> set = map.entrySet();
        for (Map.Entry<Integer, V> entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public int[] keys(int[] dest) {
        if (dest.length < this._size) {
            dest = new int[this._size];
        }
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            dest[j++] = k[i];
        }
        return dest;
    }

    public Object[] values() {
        Object[] vals = new Object[this.size()];
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public V[] values(V[] dest) {
        if (dest.length < this._size) {
            dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), this._size);
        }
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            dest[j++] = v[i];
        }
        return dest;
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<? super V> procedure) {
        byte[] states = this._states;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachValue(Consumer<? super V> procedure) {
        byte[] states = this._states;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            procedure.accept(values[i]);
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure<? super V> procedure) {
        byte[] states = this._states;
        int[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntObjectProcedure<? super V> procedure) {
        boolean modified = false;
        byte[] states = this._states;
        int[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        byte[] states = this._states;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TIntObjectProcedure<V>(){
            private boolean first = true;

            public boolean execute(int key, Object value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(",");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public void testAll() {
        if (this.size() == 1) {
            ++oneInstanceCount;
        }
    }
}

