/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.parser.matcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.PatternMatched;
import org.predict4all.nlp.parser.matcher.TermMatcherUtils;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.parser.token.Token;

public abstract class AbstractRecursiveMatcher
implements TokenMatcher {
    private final boolean allowEndWithSeparator;
    private final Separator termSeparator;
    private final String wordRegex;
    private final EquivalenceClass equivalenceClass;

    public AbstractRecursiveMatcher(boolean allowEndWithSeparator, Separator tokenSeparator, String wordRegex, EquivalenceClass equivalenceClass) {
        this.allowEndWithSeparator = allowEndWithSeparator;
        this.termSeparator = tokenSeparator;
        this.wordRegex = wordRegex;
        this.equivalenceClass = equivalenceClass;
    }

    public AbstractRecursiveMatcher(boolean allowEndWithSeparator, Separator termSeparator, String wordRegex) {
        this(allowEndWithSeparator, termSeparator, wordRegex, null);
    }

    @Override
    public PatternMatched match(Token token, TokenProvider tokenFis) throws IOException {
        Pattern pattern = TermMatcherUtils.getPattern(this.wordRegex, 0);
        ArrayList<String> founds = new ArrayList<String>(4);
        boolean wantWord = true;
        Token lastMatchToken = null;
        while (token != null) {
            if (wantWord && token.isWord() && pattern.matcher(token.getText()).matches()) {
                founds.add(token.getText());
                lastMatchToken = token;
                wantWord = false;
            } else {
                if (wantWord || !token.isSeparator() || token.getSeparator() != this.termSeparator) break;
                wantWord = true;
                if (this.allowEndWithSeparator) {
                    lastMatchToken = token;
                }
            }
            token = token.getNext(tokenFis);
        }
        if (founds.size() > 1 && (this.allowEndWithSeparator || !wantWord)) {
            return new PatternMatched(this.equivalenceClass, this.createMatchedString(founds), lastMatchToken);
        }
        return null;
    }

    protected abstract String createMatchedString(List<String> var1);
}

