/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.parser.matcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.TokenRegexMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexResult;
import org.predict4all.nlp.parser.token.Token;

public class TermMatcherUtils {
    private static Map<String, Pattern> CACHED_PATTERN = new HashMap<String, Pattern>(20);

    private TermMatcherUtils() {
    }

    public static TokenRegexResult matchRegexPattern(Token token, TokenRegexMatcher tokenRegexMatcher, TokenProvider tokenProvider, int flags) throws IOException {
        Token current;
        ArrayList<String> values = new ArrayList<String>();
        Token lastMatchedToken = current = token;
        while (tokenRegexMatcher != null) {
            Pattern pattern = TermMatcherUtils.getPattern(tokenRegexMatcher.getRegex(), flags);
            if (current != null || tokenRegexMatcher.isOptional()) {
                if (current != null && pattern.matcher(current.getText()).matches()) {
                    if (tokenRegexMatcher.isCaptureValue()) {
                        values.add(current.getText());
                    }
                    lastMatchedToken = current;
                    current = current.getNext(tokenProvider);
                } else if (!tokenRegexMatcher.isOptional()) {
                    return null;
                }
            } else {
                return null;
            }
            tokenRegexMatcher = tokenRegexMatcher.getNext();
        }
        return new TokenRegexResult(lastMatchedToken, values);
    }

    public static Pattern getPattern(String regex, int flags) {
        if (CACHED_PATTERN.containsKey(regex)) {
            return CACHED_PATTERN.get(regex);
        }
        Pattern pattern = Pattern.compile(regex, flags);
        CACHED_PATTERN.put(regex, pattern);
        return pattern;
    }
}

