/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.parser.matcher;

import java.util.regex.Pattern;
import org.predict4all.nlp.Separator;

public class TokenRegexMatcher {
    private final String regex;
    private final boolean optional;
    private final boolean captureValue;
    private TokenRegexMatcher next;

    private TokenRegexMatcher(String regex, boolean optional, boolean captureValue) {
        this.regex = regex;
        this.optional = optional;
        this.captureValue = captureValue;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isCaptureValue() {
        return this.captureValue;
    }

    public TokenRegexMatcher getNext() {
        return this.next;
    }

    public static class TokenRegexMatcherBuilder {
        private TokenRegexMatcher first;
        private TokenRegexMatcher current;

        public static TokenRegexMatcherBuilder start() {
            return new TokenRegexMatcherBuilder();
        }

        public TokenRegexMatcher build() {
            return this.first;
        }

        private TokenRegexMatcherBuilder addMatcher(TokenRegexMatcher matcher) {
            if (this.current != null) {
                this.current.next = matcher;
            }
            this.current = matcher;
            if (this.first == null) {
                this.first = this.current;
            }
            return this;
        }

        public TokenRegexMatcherBuilder then(String regex) {
            return this.addMatcher(new TokenRegexMatcher(regex, false, false));
        }

        public TokenRegexMatcherBuilder then(Separator stopChar) {
            return this.addMatcher(new TokenRegexMatcher(Pattern.quote(stopChar.getOfficialCharString()), false, false));
        }

        public TokenRegexMatcherBuilder optional(String regex) {
            return this.addMatcher(new TokenRegexMatcher(regex, true, false));
        }

        public TokenRegexMatcherBuilder optional(Separator stopChar) {
            return this.optional(Pattern.quote(stopChar.getOfficialCharString()));
        }

        public TokenRegexMatcherBuilder capture(String regex) {
            return this.addMatcher(new TokenRegexMatcher(regex, false, true));
        }

        public TokenRegexMatcherBuilder or(Separator ... stopChars) {
            StringBuilder then = new StringBuilder();
            for (Separator stopChar : stopChars) {
                then.append(then.length() > 0 ? "|" : "");
                then.append(Pattern.quote(stopChar.getOfficialCharString()));
            }
            return this.then(then.toString());
        }

        public TokenRegexMatcherBuilder or(Separator c1, String c2) {
            return this.then(Pattern.quote(c1.getOfficialCharString()) + "|" + Pattern.quote(c2));
        }

        public TokenRegexMatcherBuilder or(String ... values) {
            StringBuilder then = new StringBuilder();
            for (String value : values) {
                then.append(then.length() > 0 ? "|" : "");
                then.append(Pattern.quote(value));
            }
            return this.then(then.toString());
        }
    }
}

