/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.parser.token;

import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.token.Token;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.words.WordDictionary;

abstract class AbstractToken
implements Token {
    private Token next;
    private int cachedWordId = -1;

    @Override
    public int getWordId(WordDictionary dictionary) {
        if (this.cachedWordId < 0 || this.cachedWordId == Tag.UNKNOWN.getId()) {
            if (this.isTag()) {
                this.cachedWordId = this.getTag().getId();
            } else if (this.isEquivalenceClass()) {
                this.cachedWordId = this.getEquivalenceClass().getId();
            } else {
                String text = this.getText();
                this.cachedWordId = dictionary.getWordId(text);
                if (this.cachedWordId == Tag.UNKNOWN.getId() && Predict4AllUtils.containsUpperCase(text)) {
                    this.cachedWordId = dictionary.getWordId(Predict4AllUtils.lowerCase(text));
                }
            }
        }
        return this.cachedWordId;
    }

    protected AbstractToken() {
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public Separator getSeparator() {
        return null;
    }

    @Override
    public Token getNext(TokenProvider nextTokenProvider) throws IOException {
        if (this.next == null) {
            this.next = nextTokenProvider.getNext();
        }
        return this.next;
    }

    @Override
    public void clearNextCache() {
        this.next = null;
    }

    @Override
    public boolean isWord() {
        return false;
    }

    @Override
    public String getTextForType() {
        return this.isSeparator() ? this.getSeparator().getOfficialCharString() : this.getText();
    }

    @Override
    public boolean isSeparator() {
        return false;
    }

    @Override
    public boolean isEquivalenceClass() {
        return false;
    }

    @Override
    public EquivalenceClass getEquivalenceClass() {
        return null;
    }

    @Override
    public boolean isTag() {
        return false;
    }

    @Override
    public Tag getTag() {
        return null;
    }

    public String toString() {
        return "(\"" + this.getText() + "\"/" + (Object)((Object)this.getSeparator()) + "/" + (Object)((Object)this.getEquivalenceClass()) + ")";
    }
}

