/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.prediction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.predict4all.nlp.language.LanguageModel;
import org.predict4all.nlp.words.correction.CorrectionRuleNode;

public class PredictionParameter {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    @Expose
    private boolean addNewWordsEnabled = true;
    @Expose
    private int minUseCountToValidateNewWord = 10;
    @Expose
    private boolean dynamicModelEnabled = true;
    @Expose
    private int minCountToProvidePrediction = 0;
    @Expose
    private int minCountToProvideCorrection = 0;
    @Expose
    private double dynamicModelMinimumWeight = 0.05;
    @Expose
    private boolean enableWordCorrection = false;
    @Expose
    private double correctionMaxCost = 3.5;
    @Expose
    private double correctionDefaultFactor = 0.5;
    @Expose
    private double correctionDefaultCost = 1.0;
    @Expose
    private boolean enableDebugInformation = false;
    @Expose
    private CorrectionRuleNode correctionRulesRoot;
    @Expose
    private Map<String, String> customParameters;
    private LanguageModel languageModel;

    public PredictionParameter(LanguageModel languageModel) {
        this.languageModel = languageModel;
    }

    public boolean isAddNewWordsEnabled() {
        return this.addNewWordsEnabled;
    }

    public PredictionParameter setAddNewWordsEnabled(boolean addNewWordsEnabled) {
        this.addNewWordsEnabled = addNewWordsEnabled;
        return this;
    }

    public boolean isDynamicModelEnabled() {
        return this.dynamicModelEnabled;
    }

    public PredictionParameter setDynamicModelEnabled(boolean dynamicModelEnabled) {
        this.dynamicModelEnabled = dynamicModelEnabled;
        return this;
    }

    public double getDynamicModelMinimumWeight() {
        return this.dynamicModelMinimumWeight;
    }

    public PredictionParameter setDynamicModelMinimumWeight(double dynamicModelMinimumWeight) {
        this.dynamicModelMinimumWeight = dynamicModelMinimumWeight;
        return this;
    }

    public LanguageModel getLanguageModel() {
        return this.languageModel;
    }

    public PredictionParameter setLanguageModel(LanguageModel languageModel) {
        this.languageModel = languageModel;
        return this;
    }

    public int getMinUseCountToValidateNewWord() {
        return this.minUseCountToValidateNewWord;
    }

    public PredictionParameter setMinUseCountToValidateNewWord(int minUseCountToValidateNewWord) {
        this.minUseCountToValidateNewWord = minUseCountToValidateNewWord;
        return this;
    }

    public boolean isEnableWordCorrection() {
        return this.enableWordCorrection;
    }

    public PredictionParameter setEnableWordCorrection(boolean enableWordCorrection) {
        this.enableWordCorrection = enableWordCorrection;
        return this;
    }

    public double getCorrectionMaxCost() {
        return this.correctionMaxCost;
    }

    public PredictionParameter setCorrectionMaxCost(double correctionMaxCost) {
        this.correctionMaxCost = correctionMaxCost;
        return this;
    }

    public double getCorrectionDefaultFactor() {
        return this.correctionDefaultFactor;
    }

    public PredictionParameter setCorrectionDefaultFactor(double correctionDefaultFactor) {
        this.correctionDefaultFactor = correctionDefaultFactor;
        return this;
    }

    public double getCorrectionDefaultCost() {
        return this.correctionDefaultCost;
    }

    public PredictionParameter setCorrectionDefaultCost(double correctionDefaultCost) {
        this.correctionDefaultCost = correctionDefaultCost;
        return this;
    }

    public CorrectionRuleNode getCorrectionRulesRoot() {
        return this.correctionRulesRoot;
    }

    public PredictionParameter setCorrectionRulesRoot(CorrectionRuleNode correctionRulesRoot) {
        this.correctionRulesRoot = correctionRulesRoot;
        return this;
    }

    public int getMinCountToProvidePrediction() {
        return this.minCountToProvidePrediction;
    }

    public PredictionParameter setMinCountToProvidePrediction(int minCountToProvidePrediction) {
        this.minCountToProvidePrediction = minCountToProvidePrediction;
        return this;
    }

    public int getMinCountToProvideCorrection() {
        return this.minCountToProvideCorrection;
    }

    public PredictionParameter setMinCountToProvideCorrection(int minCountToProvideCorrection) {
        this.minCountToProvideCorrection = minCountToProvideCorrection;
        return this;
    }

    public boolean isEnableDebugInformation() {
        return this.enableDebugInformation;
    }

    public PredictionParameter setEnableDebugInformation(boolean enableDebugInformation) {
        this.enableDebugInformation = enableDebugInformation;
        return this;
    }

    public Map<String, String> getCustomParameters() {
        if (this.customParameters == null) {
            this.customParameters = new HashMap<String, String>();
        }
        return this.customParameters;
    }

    public void saveTo(File file) throws IOException {
        try (PrintWriter pw = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            GSON.toJson((Object)this, (Appendable)pw);
        }
    }

    public static PredictionParameter loadFrom(LanguageModel languageModel, File file) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8.name());){
            PredictionParameter param = (PredictionParameter)GSON.fromJson((Reader)inputStreamReader, PredictionParameter.class);
            param.setLanguageModel(languageModel);
            PredictionParameter predictionParameter = param;
            return predictionParameter;
        }
    }
}

