/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.prediction.model;

import org.predict4all.nlp.prediction.model.AbstractPredictionToCompute;
import org.predict4all.nlp.words.WordDictionary;

public class DoublePredictionToCompute
extends AbstractPredictionToCompute {
    private final boolean spaceBetween;
    private final int[] firstPrefix;
    private final int[] secondPrefix;
    private final int firstWordId;
    private final int secondWordId;

    public DoublePredictionToCompute(int firstWordId, int secondWordId, boolean spaceBetween, int[] firstPrefix, int[] secondPrefix, double factor, boolean correction, StringBuilder debugInformation) {
        this.spaceBetween = spaceBetween;
        this.firstPrefix = firstPrefix;
        this.secondPrefix = secondPrefix;
        this.firstWordId = firstWordId;
        this.secondWordId = secondWordId;
        this.factor = factor;
        this.correction = correction;
        this.debugInformation = debugInformation;
    }

    @Override
    public int getWordId() {
        return this.firstWordId;
    }

    public int[] getFirstPrefix() {
        return this.firstPrefix;
    }

    public int[] getSecondPrefix() {
        return this.secondPrefix;
    }

    public int getFirstWordId() {
        return this.firstWordId;
    }

    public int getSecondWordId() {
        return this.secondWordId;
    }

    public boolean isSpaceBetween() {
        return this.spaceBetween;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public void computePrediction(WordDictionary wordDictionary) {
        this.prediction = wordDictionary.getWord(this.firstWordId).getWord() + (this.spaceBetween ? " " : "") + wordDictionary.getWord(this.secondWordId).getWord();
    }
}

