/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.trainer.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.predict4all.nlp.trainer.configuration.NGramPruningMethod;

public class TrainingConfiguration {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    @Expose
    private int ngramOrder = 4;
    @Expose
    private double upperCaseReplacementThreshold = 0.35;
    @Expose
    private double convertCaseFromDictionaryModelThreshold = 1.0E-8;
    @Expose
    private int unknownWordCountThreshold = 0;
    @Expose
    private int directlyValidWordCountThreshold = 20;
    @Expose
    private NGramPruningMethod pruningMethod = NGramPruningMethod.ORDER_COUNT;
    @Expose
    private double ngramPruningWeightedDifferenceThreshold = 1.0E-4;
    @Expose
    private int ngramPruningCountThreshold = 2;
    @Expose
    private int[] ngramPruningOrderCountThresholds = new int[]{-1, 2, 3, 4};
    @Expose
    private double smoothingDiscountValue = -1.0;
    @Expose
    private double smoothingDiscountValueLowerBound = 0.1;
    @Expose
    private double smoothingDiscountValueUpperBound = 1.0;
    @Expose
    private int lsaWindowSize = 100;
    @Expose
    private int lsaFrequentWordSize = 5000;
    @Expose
    private int lsaVocabularySize = 80000;
    @Expose
    private int lsaTargetSvdSize = 200;
    @Expose
    private int lsaDensitySize = 100;
    @Expose
    private String baseWordDictionaryPath;
    @Expose
    private String stopWordDictionaryPath;
    private transient File corpus;

    private TrainingConfiguration(File corpus) {
        this.corpus = corpus;
    }

    private TrainingConfiguration(TrainingConfiguration other) {
        this.ngramOrder = other.ngramOrder;
        this.upperCaseReplacementThreshold = other.upperCaseReplacementThreshold;
        this.convertCaseFromDictionaryModelThreshold = other.convertCaseFromDictionaryModelThreshold;
        this.unknownWordCountThreshold = other.unknownWordCountThreshold;
        this.directlyValidWordCountThreshold = other.directlyValidWordCountThreshold;
        this.pruningMethod = other.pruningMethod;
        this.ngramPruningWeightedDifferenceThreshold = other.ngramPruningWeightedDifferenceThreshold;
        this.ngramPruningCountThreshold = other.ngramPruningCountThreshold;
        this.ngramPruningOrderCountThresholds = other.ngramPruningOrderCountThresholds;
        this.smoothingDiscountValue = other.smoothingDiscountValue;
        this.smoothingDiscountValueLowerBound = other.smoothingDiscountValueLowerBound;
        this.smoothingDiscountValueUpperBound = other.smoothingDiscountValueUpperBound;
        this.lsaWindowSize = other.lsaWindowSize;
        this.lsaFrequentWordSize = other.lsaFrequentWordSize;
        this.lsaVocabularySize = other.lsaVocabularySize;
        this.lsaTargetSvdSize = other.lsaTargetSvdSize;
        this.lsaDensitySize = other.lsaDensitySize;
        this.baseWordDictionaryPath = other.baseWordDictionaryPath;
        this.stopWordDictionaryPath = other.stopWordDictionaryPath;
        this.corpus = other.corpus;
    }

    public File getCorpus() {
        return this.corpus;
    }

    private void setCorpus(File corpus) {
        this.corpus = corpus;
    }

    public int getNgramOrder() {
        return this.ngramOrder;
    }

    public void setNgramOrder(int ngramOrder) {
        this.ngramOrder = ngramOrder;
    }

    public double getUpperCaseReplacementThreshold() {
        return this.upperCaseReplacementThreshold;
    }

    public void setUpperCaseReplacementThreshold(double upperCaseReplacementThreshold) {
        this.upperCaseReplacementThreshold = upperCaseReplacementThreshold;
    }

    public double getConvertCaseFromDictionaryModelThreshold() {
        return this.convertCaseFromDictionaryModelThreshold;
    }

    public void setConvertCaseFromDictionaryModelThreshold(double convertCaseFromDictionaryModelThreshold) {
        this.convertCaseFromDictionaryModelThreshold = convertCaseFromDictionaryModelThreshold;
    }

    public int getUnknownWordCountThreshold() {
        return this.unknownWordCountThreshold;
    }

    public void setUnknownWordCountThreshold(int unknownWordCountThreshold) {
        this.unknownWordCountThreshold = unknownWordCountThreshold;
    }

    public int getDirectlyValidWordCountThreshold() {
        return this.directlyValidWordCountThreshold;
    }

    public void setDirectlyValidWordCountThreshold(int directlyValidWordCountThreshold) {
        this.directlyValidWordCountThreshold = directlyValidWordCountThreshold;
    }

    public NGramPruningMethod getPruningMethod() {
        return this.pruningMethod;
    }

    public void setPruningMethod(NGramPruningMethod pruningMethod) {
        this.pruningMethod = pruningMethod;
    }

    public double getNgramPruningWeightedDifferenceThreshold() {
        return this.ngramPruningWeightedDifferenceThreshold;
    }

    public void setNgramPruningWeightedDifferenceThreshold(double ngramPruningWeightedDifferenceThreshold) {
        this.ngramPruningWeightedDifferenceThreshold = ngramPruningWeightedDifferenceThreshold;
    }

    public int getNgramPruningCountThreshold() {
        return this.ngramPruningCountThreshold;
    }

    public void setNgramPruningCountThreshold(int ngramPruningCountThreshold) {
        this.ngramPruningCountThreshold = ngramPruningCountThreshold;
    }

    public int[] getNgramPruningOrderCountThresholds() {
        return this.ngramPruningOrderCountThresholds;
    }

    public void setNgramPruningOrderCountThresholds(int[] ngramPruningOrderCountThresholds) {
        this.ngramPruningOrderCountThresholds = ngramPruningOrderCountThresholds;
    }

    public double getSmoothingDiscountValue() {
        return this.smoothingDiscountValue;
    }

    public void setSmoothingDiscountValue(double smoothingDiscountValue) {
        this.smoothingDiscountValue = smoothingDiscountValue;
    }

    public double getSmoothingDiscountValueLowerBound() {
        return this.smoothingDiscountValueLowerBound;
    }

    public void setSmoothingDiscountValueLowerBound(double smoothingDiscountValueLowerBound) {
        this.smoothingDiscountValueLowerBound = smoothingDiscountValueLowerBound;
    }

    public double getSmoothingDiscountValueUpperBound() {
        return this.smoothingDiscountValueUpperBound;
    }

    public void setSmoothingDiscountValueUpperBound(double smoothingDiscountValueUpperBound) {
        this.smoothingDiscountValueUpperBound = smoothingDiscountValueUpperBound;
    }

    public int getLsaWindowSize() {
        return this.lsaWindowSize;
    }

    public void setLsaWindowSize(int lsaWindowSize) {
        this.lsaWindowSize = lsaWindowSize;
    }

    public int getLsaFrequentWordSize() {
        return this.lsaFrequentWordSize;
    }

    public void setLsaFrequentWordSize(int lsaFrequentWordSize) {
        this.lsaFrequentWordSize = lsaFrequentWordSize;
    }

    public int getLsaVocabularySize() {
        return this.lsaVocabularySize;
    }

    public void setLsaVocabularySize(int lsaVocabularySize) {
        this.lsaVocabularySize = lsaVocabularySize;
    }

    public int getLsaTargetSvdSize() {
        return this.lsaTargetSvdSize;
    }

    public void setLsaTargetSvdSize(int lsaTargetSvdSize) {
        this.lsaTargetSvdSize = lsaTargetSvdSize;
    }

    public int getLsaDensitySize() {
        return this.lsaDensitySize;
    }

    public void setLsaDensitySize(int lsaDensitySize) {
        this.lsaDensitySize = lsaDensitySize;
    }

    public String getBaseWordDictionaryPath() {
        return this.baseWordDictionaryPath;
    }

    public void setBaseWordDictionaryPath(String baseWordDictionaryPath) {
        this.baseWordDictionaryPath = baseWordDictionaryPath;
    }

    public String getStopWordDictionaryPath() {
        return this.stopWordDictionaryPath;
    }

    public void setStopWordDictionaryPath(String stopWordDictionaryPath) {
        this.stopWordDictionaryPath = stopWordDictionaryPath;
    }

    public static TrainingConfiguration defaultConfiguration() {
        return TrainingConfiguration.defaultConfiguration(null);
    }

    public static TrainingConfiguration defaultConfiguration(File corpus) {
        return new TrainingConfiguration(corpus);
    }

    public static TrainingConfiguration from(TrainingConfiguration other) {
        return new TrainingConfiguration(other);
    }

    public void saveTo(File file) throws IOException {
        try (PrintWriter pw = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            GSON.toJson((Object)this, (Appendable)pw);
        }
    }

    public static TrainingConfiguration loadFrom(File file, File corpus) throws IOException {
        StringBuilder content = new StringBuilder();
        try (Scanner scan = new Scanner(file, StandardCharsets.UTF_8.name());){
            while (scan.hasNextLine()) {
                content.append(scan.nextLine()).append("\n");
            }
        }
        TrainingConfiguration loaded = (TrainingConfiguration)GSON.fromJson(content.toString(), TrainingConfiguration.class);
        loaded.setCorpus(corpus);
        return loaded;
    }
}

