/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.trainer.corpus;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.predict4all.nlp.trainer.step.TrainingStep;

public abstract class AbstractTrainingDocument {
    public static final String INFO_EXTENSION = ".info";
    public static final String OUTPUT_EXTENSION = ".bin";
    private final TrainingStep step;
    protected final String encoding;
    protected final File inputFile;
    protected final File outputFile;
    protected int count;

    public AbstractTrainingDocument(TrainingStep step, String encoding, File inputFile, File outputDirectory) {
        this.step = step;
        this.encoding = encoding;
        TrainingStep previousStep = step.getPreviousStep();
        File file = this.inputFile = previousStep != null ? new File(outputDirectory.getPath() + File.separator + previousStep.getOutputDirectoryName() + File.separator + inputFile.getName() + OUTPUT_EXTENSION) : inputFile;
        if (step.getOutputDirectoryName() != null) {
            File outputDir = new File(outputDirectory.getPath() + File.separator + step.getOutputDirectoryName());
            outputDir.mkdirs();
            this.outputFile = new File(outputDir.getPath() + File.separator + inputFile.getName() + OUTPUT_EXTENSION);
        } else {
            this.outputFile = null;
        }
        try {
            this.initializeInformation();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize informations for " + inputFile, e);
        }
    }

    protected abstract void initializeInformation() throws IOException;

    public TrainingStep getStep() {
        return this.step;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public int getCount() {
        return this.count;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void writeInformations(int outputCount) {
        try (PrintWriter pw = new PrintWriter(this.outputFile + INFO_EXTENSION, StandardCharsets.UTF_8.name());){
            pw.println(outputCount);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't write information for output file " + this.outputFile, e);
        }
    }
}

