/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.trainer.corpus;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.predict4all.nlp.trainer.corpus.AbstractTrainingDocument;
import org.predict4all.nlp.trainer.step.TrainingStep;

public class TrainingCorpus {
    private final File outputDirectory;
    private final int concurrencyLevel;
    private final Map<TrainingStep, List<AbstractTrainingDocument>> documentsByStep;
    private final String encoding;
    private final File[] inputFiles;

    public TrainingCorpus(int concurrencyLevel, File inputDirectory, File outputDirectory, String encoding) throws IOException {
        this.encoding = encoding;
        this.concurrencyLevel = concurrencyLevel;
        this.outputDirectory = outputDirectory;
        this.documentsByStep = new HashMap<TrainingStep, List<AbstractTrainingDocument>>();
        this.inputFiles = (File[])Arrays.stream(inputDirectory.listFiles()).filter(f -> !f.getName().endsWith(".info.json")).toArray(File[]::new);
    }

    public void initStep(TrainingStep step) {
        this.documentsByStep.put(step, ((Stream)Arrays.stream(this.inputFiles).parallel()).map(d -> step.getStep((File)d, this)).collect(Collectors.toList()));
    }

    public int getTotalCountFor(TrainingStep step) {
        return this.documentsByStep.get((Object)step).stream().mapToInt(AbstractTrainingDocument::getCount).sum();
    }

    public List<AbstractTrainingDocument> getDocuments(TrainingStep step) {
        return this.documentsByStep.get((Object)step);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

