/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.trainer.step;

import java.io.File;
import java.util.function.BiFunction;
import org.predict4all.nlp.trainer.corpus.AbstractTrainingDocument;
import org.predict4all.nlp.trainer.corpus.TrainingCorpus;
import org.predict4all.nlp.trainer.step.NGramTrainingDocument;
import org.predict4all.nlp.trainer.step.ParserTrainingDocument;
import org.predict4all.nlp.trainer.step.SemanticTrainingDocument;
import org.predict4all.nlp.trainer.step.TokenConverterTrainingDocument;
import org.predict4all.nlp.trainer.step.WordDictionaryTrainingDocument;

public enum TrainingStep {
    PARSER(null, "raw-tokens", (file, corpus) -> new ParserTrainingDocument(corpus.getEncoding(), (File)file, corpus.getOutputDirectory())),
    TOKEN_CONVERT(PARSER, "converted-tokens", (file, corpus) -> new TokenConverterTrainingDocument((File)file, corpus.getOutputDirectory())),
    WORDS_DICTIONARY(TOKEN_CONVERT, "clean-tokens", (file, corpus) -> new WordDictionaryTrainingDocument((File)file, corpus.getOutputDirectory())),
    NGRAM_DICTIONARY(WORDS_DICTIONARY, null, (file, corpus) -> new NGramTrainingDocument((File)file, corpus.getOutputDirectory())),
    SEMANTIC_DICTIONARY(WORDS_DICTIONARY, null, (file, corpus) -> new SemanticTrainingDocument((File)file, corpus.getOutputDirectory()));

    private final BiFunction<File, TrainingCorpus, AbstractTrainingDocument> stepDocumentSupplier;
    private final String outputDirectoryName;
    private final TrainingStep previousStep;

    private TrainingStep(TrainingStep previousStep, String outputDirectoryName, BiFunction<File, TrainingCorpus, AbstractTrainingDocument> stepDocumentSupplier) {
        this.previousStep = previousStep;
        this.outputDirectoryName = outputDirectoryName;
        this.stepDocumentSupplier = stepDocumentSupplier;
    }

    public String getOutputDirectoryName() {
        return this.outputDirectoryName;
    }

    public TrainingStep getPreviousStep() {
        return this.previousStep;
    }

    public AbstractTrainingDocument getStep(File documentFile, TrainingCorpus corpus) {
        return this.stepDocumentSupplier.apply(documentFile, corpus);
    }
}

