/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;

public class FifoSet<T> {
    private final int maxSize;
    private final HashMap<T, LongAdder> countMap;
    private final ArrayList<T> list;

    public FifoSet(int maxSize) {
        this.maxSize = maxSize;
        this.list = new ArrayList(maxSize + 3);
        this.countMap = new HashMap(maxSize + 10);
    }

    public void add(T element) {
        this.list.add(element);
        this.countMap.computeIfAbsent(element, e -> new LongAdder()).increment();
        if (this.list.size() > this.maxSize) {
            T first = this.list.remove(0);
            LongAdder firstCount = this.countMap.get(first);
            if (firstCount.sum() <= 1L) {
                this.countMap.remove(first);
            } else {
                firstCount.decrement();
            }
        }
    }

    public Set<T> getSet() {
        return this.countMap.keySet();
    }

    public int size() {
        return this.countMap.size();
    }

    public boolean contains(T element) {
        return this.countMap.containsKey(element);
    }

    public void clear() {
        this.list.clear();
        this.countMap.clear();
    }

    public Map<T, LongAdder> getCountMap() {
        return this.countMap;
    }
}

