/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.predict4all.nlp.Separator;

public class Predict4AllUtils {
    private Predict4AllUtils() {
    }

    public static <T> T getOrDefault(T currentVal, T newVal) {
        return currentVal != null ? currentVal : newVal;
    }

    public static <T> T checkNull(T param, String message) throws IllegalArgumentException {
        if (param == null) {
            throw new IllegalArgumentException(message);
        }
        return param;
    }

    @SafeVarargs
    public static <T> Map<T, T> createMap(T ... keyValues) {
        HashMap<T, T> map = new HashMap<T, T>(keyValues.length);
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        int[] retArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            retArray[i] = array[i];
        }
        return retArray;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !Predict4AllUtils.isBlank(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String capitalize(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return str;
        }
        char firstC = str.charAt(0);
        if (Character.isTitleCase(firstC)) {
            return str;
        }
        return new StringBuilder(length).append(Character.toTitleCase(firstC)).append(str.substring(1)).toString();
    }

    public static String upperCase(String str) {
        return str != null ? str.toUpperCase() : null;
    }

    public static String lowerCase(String str) {
        return str != null ? str.toLowerCase() : null;
    }

    public static boolean isCapitalized(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return Character.isUpperCase(str.charAt(0));
    }

    public static boolean isFullUpperCase(String str) {
        if (str == null || Predict4AllUtils.isEmpty(str)) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsUpperCase(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int c = 0; c < str.length(); ++c) {
            if (!Character.isUpperCase(str.charAt(c))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static int length(String str) {
        return str != null ? str.length() : 0;
    }

    public static boolean endsWith(String str, String end) {
        return str != null && end != null ? str.endsWith(end) : str == end;
    }

    public static String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean strEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null || str1.length() != str2.length()) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean strEqualsIgnoreCase(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null || str1.length() != str2.length()) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String[] strSplit(String str, String splitter) {
        String[] stringArray;
        if (str == null || splitter == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        } else {
            stringArray = str.split(Pattern.quote(splitter));
        }
        return stringArray;
    }

    public static String getEndUntilNextSeparator(String text) {
        return Predict4AllUtils.getUntilNextSeparator(text, 1);
    }

    public static String getStartUntilNextSeparator(String text) {
        return Predict4AllUtils.getUntilNextSeparator(text, -1);
    }

    public static int countStartUntilNextSeparator(String text) {
        return Predict4AllUtils.countUntilNextSeparator(text, -1);
    }

    public static int countEndUntilNextSeparator(String text) {
        return Predict4AllUtils.countUntilNextSeparator(text, 1);
    }

    private static String getUntilNextSeparator(String text, int direction) {
        StringBuilder currentText = new StringBuilder();
        if (text != null) {
            int i;
            int n = i = direction > 0 ? 0 : text.length() - 1;
            while (i < text.length() && i >= 0) {
                char currentChar = text.charAt(i);
                if (Separator.getSeparatorFor(currentChar) != null) {
                    return currentText.toString();
                }
                if (direction > 0) {
                    currentText.append(currentChar);
                } else {
                    currentText.insert(0, currentChar);
                }
                i += direction;
            }
        }
        return currentText.toString();
    }

    private static int countUntilNextSeparator(String text, int direction) {
        int count = 0;
        if (text != null) {
            int i;
            int n = i = direction > 0 ? 0 : text.length() - 1;
            while (i < text.length() && i >= 0) {
                char currentChar = text.charAt(i);
                if (Separator.getSeparatorFor(currentChar) != null) {
                    return count;
                }
                ++count;
                i += direction;
            }
        }
        return count;
    }
}

