/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.utils.progressindicator;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.predict4all.nlp.utils.progressindicator.ProgressIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingProgressIndicator
implements ProgressIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingProgressIndicator.class);
    private final String name;
    private final long max;
    private AtomicLong count;
    private AtomicInteger lastPercent = new AtomicInteger(-1);

    public LoggingProgressIndicator(String name, long max) {
        this.max = max;
        this.name = name;
        this.count = new AtomicLong();
    }

    @Override
    public void increment() {
        if (this.max > 0L) {
            this.count.incrementAndGet();
            this.printPercent();
        }
    }

    @Override
    public long getMax() {
        return this.max;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    private void printPercent() {
        int percent = (int)(1.0 * (double)this.count.get() / (1.0 * (double)this.max) * 100.0);
        if (percent != this.lastPercent.getAndSet(percent) && this.lastPercent.get() % 5 == 0) {
            LOGGER.info("{} progress : {}%", (Object)this.name, (Object)this.lastPercent.get());
        }
    }
}

