/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words;

import org.predict4all.nlp.Separator;

public class NextWord {
    private final boolean correction;
    private final double factor;
    private final int wordId1;
    private final int wordId2;
    private final StringBuilder debugInformation;
    private final Separator separator;

    private NextWord(double factor, boolean correction, int wordId1, int wordId2, Separator separator, StringBuilder debugInformation) {
        this.factor = factor;
        this.wordId1 = wordId1;
        this.wordId2 = wordId2;
        this.separator = separator;
        this.correction = correction;
        this.debugInformation = debugInformation;
    }

    private NextWord(double factor, boolean correction, int wordId1, StringBuilder debugInformation) {
        this(factor, correction, wordId1, -1, null, debugInformation);
    }

    public static NextWord createUnique(int wordId, double factor, boolean correction, StringBuilder debugInformation) {
        return new NextWord(factor, correction, wordId, debugInformation);
    }

    public static NextWord createDouble(int wordId1, int wordId2, Separator separator, double factor, boolean correction, StringBuilder debugInformation) {
        return new NextWord(factor, correction, wordId1, wordId2, separator, debugInformation);
    }

    public double getFactor() {
        return this.factor;
    }

    public int getWordId1() {
        return this.wordId1;
    }

    public int getWordId2() {
        return this.wordId2;
    }

    public StringBuilder getDebugInformation() {
        return this.debugInformation;
    }

    public boolean isUnique() {
        return this.wordId2 < 0;
    }

    public boolean isDouble() {
        return this.wordId2 >= 0;
    }

    public Separator getSeparator() {
        return this.separator;
    }

    public boolean isCorrection() {
        return this.correction;
    }

    public String toString() {
        return "NextWord [factor=" + this.factor + ", wordId1=" + this.wordId1 + ", wordId2=" + this.wordId2 + ", debugInformation=" + this.debugInformation + "]";
    }
}

