/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.exception.WordDictionaryMatchingException;
import org.predict4all.nlp.io.WordFileInputStream;
import org.predict4all.nlp.io.WordFileOutputStream;
import org.predict4all.nlp.language.LanguageModel;
import org.predict4all.nlp.parser.token.Token;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.utils.BiIntegerKey;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.words.NextWord;
import org.predict4all.nlp.words.model.EquivalenceClassWord;
import org.predict4all.nlp.words.model.SimpleWord;
import org.predict4all.nlp.words.model.TagWord;
import org.predict4all.nlp.words.model.UserWord;
import org.predict4all.nlp.words.model.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordDictionary.class);
    private final AtomicInteger idGenerator;
    private final TIntObjectHashMap<Word> wordsById;
    private final PatriciaTrie<Word> wordTrie;
    private final String dictionaryId;

    public WordDictionary(LanguageModel languageModel, String dictionaryId) {
        this.wordsById = new TIntObjectHashMap(languageModel.getAverageVocabularySize());
        this.wordTrie = new PatriciaTrie();
        this.idGenerator = new AtomicInteger(0);
        this.dictionaryId = dictionaryId;
        for (EquivalenceClass equivalenceClass : EquivalenceClass.values()) {
            this.putExistingWord(new EquivalenceClassWord(equivalenceClass));
        }
        for (Enum enum_ : Tag.values()) {
            this.putExistingWord(new TagWord((Tag)enum_));
        }
    }

    public int getWordId(String text) {
        return this.getWord(text).getID();
    }

    public Word getWord(String text) {
        Word word = (Word)this.wordTrie.get((Object)text);
        return word != null ? word : (Word)this.wordsById.get(Tag.UNKNOWN.getId());
    }

    public Word getWord(int wordId) {
        return (Word)this.wordsById.get(wordId);
    }

    public Map<BiIntegerKey, NextWord> getValidWordForPredictionByPrefix(String wordPrefix, PredictionParameter predictionParameter, int wantedWordCount, Set<Integer> wordIdsToExclude) {
        LOGGER.info("Request for \"{}\"", (Object)wordPrefix);
        HashMap<BiIntegerKey, NextWord> words = new HashMap<BiIntegerKey, NextWord>(wantedWordCount);
        this.searchAndAdd(wordPrefix, predictionParameter, wordIdsToExclude, words, "Du dictionnaire par le d\u00e9but de mot");
        if (words.size() < wantedWordCount && !Predict4AllUtils.isCapitalized(wordPrefix)) {
            this.searchAndAdd(Predict4AllUtils.capitalize(wordPrefix), predictionParameter, wordIdsToExclude, words, "Du dictionnaire (version capitalis\u00e9e)");
        }
        if (words.size() < wantedWordCount && Predict4AllUtils.containsUpperCase(wordPrefix)) {
            this.searchAndAdd(Predict4AllUtils.lowerCase(wordPrefix), predictionParameter, wordIdsToExclude, words, "Du dictionnaire (version lowercase)");
        }
        return words;
    }

    private void searchAndAdd(String wordPrefix, PredictionParameter predictionParameter, Set<Integer> wordIdsToExclude, Map<BiIntegerKey, NextWord> words, String debugInfo) {
        this.wordTrie.prefixMap((Object)wordPrefix).values().stream().filter(w -> w.isValidToBePredicted(predictionParameter) && !wordIdsToExclude.contains(w.getID())).forEach(w -> words.put(BiIntegerKey.of(w.getID()), NextWord.createUnique(w.getID(), 1.0, false, predictionParameter.isEnableDebugInformation() ? new StringBuilder(debugInfo) : null)));
    }

    public Collection<Word> getAllWords() {
        return this.wordsById.valueCollection();
    }

    public int size() {
        return this.wordsById.size();
    }

    public boolean isExactWordWithPrefixExist(String prefix) {
        SortedMap prefixMap = this.wordTrie.prefixMap((Object)prefix);
        return prefixMap != null && !prefixMap.isEmpty();
    }

    public SortedMap<String, Word> getExactWordsWithPrefixExist(String prefix) {
        return this.wordTrie.prefixMap((Object)prefix);
    }

    public int getIDGeneratorState() {
        return this.idGenerator.get();
    }

    public int putUserWord(Token token) {
        return this.putNewWordToDictionary(new UserWord(this.generateWordID(), token.getText()));
    }

    public Word putUserWord(String word) {
        UserWord cWord = new UserWord(this.generateWordID(), word);
        this.putNewWordToDictionary(cWord);
        return cWord;
    }

    public void incrementUserWord(int wordId) {
        Word word = (Word)this.wordsById.get(wordId);
        if (word != null && word.isUserWord()) {
            UserWord uW = (UserWord)word;
            uW.incrementUsageCount();
        }
    }

    public boolean isWordExists(String text) {
        return this.wordTrie.get((Object)text) != null;
    }

    public boolean isTokenValidToCreateUserWord(Token token) {
        String txt = token.getText();
        return Predict4AllUtils.length(txt) > 2;
    }

    public int putWordTraining(String word) {
        return this.putNewWordToDictionary(SimpleWord.create(this.generateWordID(), word));
    }

    private int putNewWordToDictionary(Word word) {
        this.wordsById.put(word.getID(), (Object)word);
        if (word.getWord() != null) {
            this.wordTrie.put((Object)word.getWord(), (Object)word);
        }
        return word.getID();
    }

    private int generateWordID() {
        return this.idGenerator.incrementAndGet();
    }

    public void compact() {
        this.wordsById.compact();
    }

    public static WordDictionary loadDictionary(LanguageModel languageModel, File dictionaryFile) throws IOException, WordDictionaryMatchingException {
        long start = System.currentTimeMillis();
        String dicId = null;
        try (WordFileInputStream wfs = new WordFileInputStream(dictionaryFile);){
            dicId = wfs.readUTF();
        }
        WordDictionary loadedDictionary = new WordDictionary(languageModel, dicId);
        int wCount = WordDictionary.loadWordsFromFile(dictionaryFile, loadedDictionary);
        LOGGER.info("{} words read from dictionary in {} ms", (Object)wCount, (Object)(System.currentTimeMillis() - start));
        return loadedDictionary;
    }

    public void loadUserDictionary(File userDictionaryFile) throws IOException, WordDictionaryMatchingException {
        long start = System.currentTimeMillis();
        int wCount = WordDictionary.loadWordsFromFile(userDictionaryFile, this);
        LOGGER.info("{} words read from user dictionary in {} ms", (Object)wCount, (Object)(System.currentTimeMillis() - start));
    }

    private static int loadWordsFromFile(File dictionaryFile, WordDictionary loadedDictionary) throws IOException, FileNotFoundException, WordDictionaryMatchingException {
        int wCount;
        block7: {
            wCount = 0;
            try (WordFileInputStream wfs = new WordFileInputStream(dictionaryFile);){
                String dictionaryID = wfs.readUTF();
                loadedDictionary.updateIDGenerator(wfs.readInt());
                if (dictionaryID.equals(loadedDictionary.dictionaryId)) {
                    Word word = wfs.readWord();
                    while (word != null) {
                        loadedDictionary.putExistingWord(word);
                        ++wCount;
                        word = wfs.readWord();
                    }
                    break block7;
                }
                throw new WordDictionaryMatchingException();
            }
        }
        loadedDictionary.compact();
        return wCount;
    }

    public void saveUserDictionary(File userDictionaryFile) throws IOException {
        long start = System.currentTimeMillis();
        int wCount = 0;
        Collection<Word> words = this.getAllWords();
        try (WordFileOutputStream wfos = new WordFileOutputStream(userDictionaryFile);){
            wfos.writeUTF(this.dictionaryId);
            wfos.writeInt(this.getIDGeneratorState());
            for (Word word : words) {
                if (!word.isUserWord() && !word.isModifiedByUserOrSystem() || !word.isValidForSaving()) continue;
                LOGGER.debug("Save user/modified word : {} (ID = {})", (Object)word, (Object)word.getID());
                wfos.writeWord(word);
                ++wCount;
            }
        }
        LOGGER.info("{} words saved to user dictionary in {} ms", (Object)wCount, (Object)(System.currentTimeMillis() - start));
    }

    private void putExistingWord(Word word) {
        this.wordsById.put(word.getID(), (Object)word);
        if (!word.isEquivalenceClass() && !word.isNGramTag()) {
            this.wordTrie.put((Object)word.getWord(), (Object)word);
        }
        this.updateIDGenerator(word.getID());
    }

    private void updateIDGenerator(int id) {
        this.idGenerator.accumulateAndGet(id, Math::max);
    }
}

