/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.parser.token.Token;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.utils.BiIntegerKey;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.words.NextWord;
import org.predict4all.nlp.words.WordDictionary;
import org.predict4all.nlp.words.WordPrefixDetected;
import org.predict4all.nlp.words.correction.WordCorrectionGenerator;

public class WordPrefixDetector {
    private static final int PREFIX_SEARCH_MAX_TOKEN_COUNT = 5;
    private final WordDictionary wordDictionary;
    private final WordCorrectionGenerator wordCorrectionGenerator;
    private final PredictionParameter predictionParameter;

    public WordPrefixDetector(WordDictionary wordDictionary, WordCorrectionGenerator wordCorrectionGenerator, PredictionParameter predictionParameter) {
        this.wordDictionary = wordDictionary;
        this.wordCorrectionGenerator = wordCorrectionGenerator;
        this.predictionParameter = predictionParameter;
    }

    public WordPrefixDetected getLongestMatchingWords(List<Token> rawTokensList, int wantedNextWordCount, Set<Integer> wordIdsToExclude) {
        Token lastToken;
        Map<BiIntegerKey, NextWord> result = null;
        StringBuilder accumulation = new StringBuilder();
        String lastCorrectionWordStart = null;
        int tokenLength = 0;
        boolean newSentenceStarted = this.isNewSentenceStarted(rawTokensList, 1);
        int endIndex = Math.max(0, rawTokensList.size() - 5);
        for (int i = rawTokensList.size() - 1; i >= endIndex; --i) {
            Token token = rawTokensList.get(i);
            accumulation.insert(0, token.getTextForType());
            if (token.getSeparator() == Separator.SPACE) break;
            String accumulationStr = newSentenceStarted ? Predict4AllUtils.lowerCase(accumulation.toString()) : accumulation.toString();
            Map<BiIntegerKey, NextWord> wordByPrefix = this.wordDictionary.getValidWordForPredictionByPrefix(accumulationStr, this.predictionParameter, wantedNextWordCount, wordIdsToExclude);
            if (this.predictionParameter.isEnableWordCorrection() && this.predictionParameter.getCorrectionMaxCost() > 0.0 && rawTokensList.size() - i <= 1) {
                this.wordCorrectionGenerator.addCorrectionsFor(accumulationStr, wordByPrefix, wordIdsToExclude);
            }
            if (!wordByPrefix.isEmpty()) {
                result = wordByPrefix;
                lastCorrectionWordStart = accumulation.toString();
                tokenLength = rawTokensList.size() - i;
                continue;
            }
            if (result != null) break;
        }
        if (lastCorrectionWordStart != null) {
            return new WordPrefixDetected(lastCorrectionWordStart, tokenLength, result, this.isNextWordsCapitalized(rawTokensList, lastCorrectionWordStart, tokenLength));
        }
        if (!rawTokensList.isEmpty() && !(lastToken = rawTokensList.get(rawTokensList.size() - 1)).isSeparator()) {
            return new WordPrefixDetected(lastToken.getText(), 1, new HashMap<BiIntegerKey, NextWord>(), this.isNextWordsCapitalized(rawTokensList, lastToken.getText(), 1));
        }
        return null;
    }

    public boolean isNextWordsCapitalized(List<Token> tokens, String longestMatchingWords, int tokenCount) {
        if (longestMatchingWords != null) {
            return Predict4AllUtils.isCapitalized(longestMatchingWords);
        }
        return this.isNewSentenceStarted(tokens, tokenCount);
    }

    private boolean isNewSentenceStarted(List<Token> tokens, int tokenCount) {
        int fromIndex;
        if (!tokens.isEmpty() && (fromIndex = tokens.size() - 1 - tokenCount) >= 0) {
            for (int i = fromIndex; i >= 0; --i) {
                Token token = tokens.get(i);
                if (!token.isSeparator()) {
                    return false;
                }
                if (!token.getSeparator().isSentenceSeparator()) continue;
                return true;
            }
        }
        return true;
    }
}

