/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.correction;

import org.predict4all.nlp.Separator;
import org.predict4all.nlp.words.correction.CorrectionRule;

public class CachedPrecomputedCorrectionRule {
    private final String error;
    private final String replacement;
    private final double factor;
    private final int maxIndexFromStart;
    private final int maxIndexFromEnd;
    private final int minIndexFromStart;
    private final int minIndexFromEnd;
    private final double cost;
    private final int replacementSeparatorIndex;
    private final Separator replacementSeparator;
    private final String replacementLeftPart;
    private final String replacementRightPart;
    private final CorrectionRule srcBuilder;

    CachedPrecomputedCorrectionRule(CorrectionRule srcBuilder, String error, String replacement, double factor, double cost, int maxIndexFromStart, int minIndexFromStart, int maxIndexFromEnd, int minIndexFromEnd) {
        this.srcBuilder = srcBuilder;
        this.error = error;
        this.replacement = replacement;
        this.factor = factor;
        this.cost = cost;
        this.maxIndexFromStart = maxIndexFromStart;
        this.minIndexFromStart = minIndexFromStart;
        this.maxIndexFromEnd = maxIndexFromEnd;
        this.minIndexFromEnd = minIndexFromEnd;
        int replacementSIndex = -1;
        Separator replacementS = null;
        for (int i = 0; i < replacement.length(); ++i) {
            char c = replacement.charAt(i);
            Separator separator = Separator.getSeparatorFor(c);
            if (separator == null) continue;
            replacementSIndex = i;
            replacementS = separator;
            break;
        }
        this.replacementSeparatorIndex = replacementSIndex;
        this.replacementSeparator = replacementS;
        this.replacementLeftPart = this.replacementSeparatorIndex >= 0 ? this.replacement.substring(0, this.replacementSeparatorIndex) : null;
        this.replacementRightPart = this.replacementSeparatorIndex >= 0 ? this.replacement.substring(this.replacementSeparatorIndex + 1, this.replacement.length()) : null;
    }

    public double getFactor() {
        return this.factor;
    }

    public String getError() {
        return this.error;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public int getMaxIndexFromStart() {
        return this.maxIndexFromStart;
    }

    public int getMinIndexFromStart() {
        return this.minIndexFromStart;
    }

    public int getMaxIndexFromEnd() {
        return this.maxIndexFromEnd;
    }

    public int getMinIndexFromEnd() {
        return this.minIndexFromEnd;
    }

    public double getCost() {
        return this.cost;
    }

    public int getReplacementSeparatorIndex() {
        return this.replacementSeparatorIndex;
    }

    public String getReplacementLeftPart() {
        return this.replacementLeftPart;
    }

    public String getReplacementRightPart() {
        return this.replacementRightPart;
    }

    public Separator getReplacementSeparator() {
        return this.replacementSeparator;
    }

    public CorrectionRule getSrcBuilder() {
        return this.srcBuilder;
    }

    public CachedPrecomputedCorrectionRule opposite() {
        return new CachedPrecomputedCorrectionRule(this.srcBuilder, this.replacement, this.error, this.factor, this.cost, this.maxIndexFromStart, this.minIndexFromStart, this.maxIndexFromEnd, this.minIndexFromEnd);
    }

    public static CachedPrecomputedCorrectionRule transitive(CachedPrecomputedCorrectionRule first, CachedPrecomputedCorrectionRule second) {
        return new CachedPrecomputedCorrectionRule(null, first.getError(), second.getReplacement(), (first.getFactor() + second.getFactor()) / 2.0, (first.getCost() + second.getCost()) / 2.0, first.getMaxIndexFromStart(), first.getMinIndexFromStart(), first.getMaxIndexFromEnd(), first.getMinIndexFromEnd());
    }

    public boolean transitivePossible(CachedPrecomputedCorrectionRule other) {
        return this.maxIndexFromEnd == other.maxIndexFromEnd && this.maxIndexFromStart == other.maxIndexFromEnd && this.minIndexFromEnd == other.minIndexFromEnd && this.minIndexFromStart == other.minIndexFromStart && !this.error.equals(other.replacement);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.cost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        temp = Double.doubleToLongBits(this.factor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxIndexFromEnd;
        result = 31 * result + this.maxIndexFromStart;
        result = 31 * result + this.minIndexFromEnd;
        result = 31 * result + this.minIndexFromStart;
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        result = 31 * result + (this.replacementLeftPart == null ? 0 : this.replacementLeftPart.hashCode());
        result = 31 * result + (this.replacementRightPart == null ? 0 : this.replacementRightPart.hashCode());
        result = 31 * result + (this.replacementSeparator == null ? 0 : this.replacementSeparator.hashCode());
        result = 31 * result + this.replacementSeparatorIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedPrecomputedCorrectionRule other = (CachedPrecomputedCorrectionRule)obj;
        if (Double.doubleToLongBits(this.cost) != Double.doubleToLongBits(other.cost)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (Double.doubleToLongBits(this.factor) != Double.doubleToLongBits(other.factor)) {
            return false;
        }
        if (this.maxIndexFromEnd != other.maxIndexFromEnd) {
            return false;
        }
        if (this.maxIndexFromStart != other.maxIndexFromStart) {
            return false;
        }
        if (this.minIndexFromEnd != other.minIndexFromEnd) {
            return false;
        }
        if (this.minIndexFromStart != other.minIndexFromStart) {
            return false;
        }
        if (this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement)) {
            return false;
        }
        if (this.replacementLeftPart == null ? other.replacementLeftPart != null : !this.replacementLeftPart.equals(other.replacementLeftPart)) {
            return false;
        }
        if (this.replacementRightPart == null ? other.replacementRightPart != null : !this.replacementRightPart.equals(other.replacementRightPart)) {
            return false;
        }
        if (this.replacementSeparator != other.replacementSeparator) {
            return false;
        }
        return this.replacementSeparatorIndex == other.replacementSeparatorIndex;
    }

    public String toString() {
        return "[" + (this.error != null ? "error=" + this.error + ", " : "") + (this.replacement != null ? "replacement=" + this.replacement : "") + "]";
    }
}

