/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.correction;

import com.google.gson.annotations.Expose;
import java.util.Arrays;
import java.util.Collection;

public class CorrectionRule {
    @Expose
    private String[] errors = new String[0];
    @Expose
    private String[] replacements = new String[0];
    @Expose
    private Double factor;
    @Expose
    private Integer maxIndexFromStart;
    @Expose
    private Integer maxIndexFromEnd;
    @Expose
    private Integer minIndexFromStart;
    @Expose
    private Integer minIndexFromEnd;
    @Expose
    private Double cost;
    @Expose
    private boolean bidirectional;

    private CorrectionRule() {
    }

    public static CorrectionRule ruleBuilder() {
        return new CorrectionRule();
    }

    public CorrectionRule withError(String ... errors) {
        this.errors = errors;
        return this;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public CorrectionRule withReplacement(String ... replacements) {
        this.replacements = replacements;
        return this;
    }

    public String[] getReplacements() {
        return this.replacements;
    }

    public CorrectionRule withFactor(double factor) {
        this.factor = factor;
        return this;
    }

    public Double getFactor() {
        return this.factor;
    }

    public CorrectionRule withCost(double cost) {
        this.cost = cost;
        return this;
    }

    public Double getCost() {
        return this.cost;
    }

    public CorrectionRule withConfusionSet(String ... elements) {
        this.errors = elements;
        this.replacements = elements;
        return this;
    }

    public CorrectionRule withMaxIndexFromStart(int maxIndexFromStart) {
        this.maxIndexFromStart = maxIndexFromStart;
        return this;
    }

    public Integer getMaxIndexFromStart() {
        return this.maxIndexFromStart;
    }

    public CorrectionRule withMaxIndexFromEnd(int maxIndexFromEnd) {
        this.maxIndexFromEnd = maxIndexFromEnd;
        return this;
    }

    public Integer getMaxIndexFromEnd() {
        return this.maxIndexFromEnd;
    }

    public CorrectionRule withMinIndexFromStart(int minIndexFromStart) {
        this.minIndexFromStart = minIndexFromStart;
        return this;
    }

    public Integer getMinIndexFromStart() {
        return this.minIndexFromStart;
    }

    public CorrectionRule withMinIndexFromEnd(int minIndexFromEnd) {
        this.minIndexFromEnd = minIndexFromEnd;
        return this;
    }

    public Integer getMinIndexFromEnd() {
        return this.minIndexFromEnd;
    }

    public CorrectionRule withBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
        return this;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void addTo(Collection<CorrectionRule> rulesCollection) {
        rulesCollection.add(this);
    }

    public String toString() {
        return "[" + (this.errors != null ? "errors=" + Arrays.toString(this.errors) + ", " : "") + (this.replacements != null ? "replacements=" + Arrays.toString(this.replacements) + ", " : "") + (this.factor != null ? "factor=" + this.factor + ", " : "") + (this.maxIndexFromStart != null ? "maxIndexFromStart=" + this.maxIndexFromStart + ", " : "") + (this.maxIndexFromEnd != null ? "maxIndexFromEnd=" + this.maxIndexFromEnd + ", " : "") + (this.minIndexFromStart != null ? "minIndexFromStart=" + this.minIndexFromStart + ", " : "") + (this.minIndexFromEnd != null ? "minIndexFromEnd=" + this.minIndexFromEnd + ", " : "") + (this.cost != null ? "cost=" + this.cost + ", " : "") + "bidirectionnal=" + this.bidirectional + "]";
    }
}

