/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.correction;

import org.predict4all.nlp.Separator;
import org.predict4all.nlp.utils.Pair;
import org.predict4all.nlp.words.correction.CachedPrecomputedCorrectionRule;
import org.predict4all.nlp.words.correction.GeneratingCorrectionI;

public class SimpleGeneratingCorrection
implements GeneratingCorrectionI {
    private String firstPart;
    private String secondPart;
    private Separator separator;
    private StringBuilder currentPart;
    private double endFactor;
    private final StringBuilder debugInformation;

    public SimpleGeneratingCorrection(String currentPart, boolean debug) {
        this.currentPart = currentPart != null ? new StringBuilder(currentPart) : null;
        this.debugInformation = debug ? new StringBuilder() : null;
    }

    private SimpleGeneratingCorrection(SimpleGeneratingCorrection other, boolean debug) {
        this((String)null, debug);
        this.currentPart = new StringBuilder(other.currentPart);
        this.firstPart = other.firstPart;
        this.secondPart = other.secondPart;
        this.separator = other.separator;
        this.endFactor = other.endFactor;
        if (this.debugInformation != null) {
            this.debugInformation.append((CharSequence)other.debugInformation);
        }
    }

    @Override
    public String getEndPart(int index) {
        return index == 0 ? this.firstPart : this.secondPart;
    }

    @Override
    public Separator getEndSeparator(int index) {
        return this.separator;
    }

    @Override
    public double getEndFactor() {
        return this.endFactor;
    }

    @Override
    public void endCorrection(double factor) {
        this.endFactor = factor;
        if (this.firstPart != null) {
            this.secondPart = this.currentPart.toString();
        } else {
            this.firstPart = this.currentPart.toString();
        }
        this.currentPart = null;
    }

    @Override
    public GeneratingCorrectionI appendDebugInformationForCurrentPart(StringBuilder before, Pair<StringBuilder, StringBuilder> result, CachedPrecomputedCorrectionRule rule) {
        if (this.debugInformation != null) {
            this.debugInformation.append((CharSequence)before).append(" > ");
            this.debugInformation.append((CharSequence)result.getLeft());
            if (result.getRight() != null) {
                this.debugInformation.append(rule.getReplacementSeparator() != Separator.APOSTROPHE ? Character.valueOf(rule.getReplacementSeparator().getOfficialChar()) : "");
                this.debugInformation.append((CharSequence)result.getRight());
            }
            this.debugInformation.append("   (").append(rule.getError()).append(" > ").append(rule.getReplacement()).append(" / ").append(rule.getCost()).append(")").append("\n");
        }
        return this;
    }

    @Override
    public StringBuilder getDebugInformation() {
        return this.debugInformation;
    }

    @Override
    public String getKey() {
        return this.secondPart != null ? this.firstPart + this.separator.getOfficialChar() + this.secondPart : this.firstPart;
    }

    @Override
    public int getPartCount() {
        return this.secondPart != null || this.firstPart != null && this.currentPart != null ? 2 : 1;
    }

    @Override
    public void currentPartFinishedAndNewPartStarted(Separator separator, StringBuilder newPartStarted) {
        if (this.separator != null) {
            throw new IllegalArgumentException("This class is not used to store generating correction with more than two parts");
        }
        this.separator = separator;
        this.firstPart = this.currentPart.toString();
        this.currentPart = newPartStarted;
    }

    @Override
    public void appendToCurrentPart(CharSequence charSequence) {
        this.currentPart.append(charSequence);
    }

    @Override
    public int getCurrentPartLength() {
        return this.currentPart.length();
    }

    @Override
    public String substringInCurrentPart(int startIndex, int endIndex) {
        return this.currentPart.substring(startIndex, endIndex);
    }

    @Override
    public int indexOfInCurrentPart(String str, int startIndexInclusive) {
        return this.currentPart.indexOf(str, startIndexInclusive);
    }

    @Override
    public void changeCurrentPartTo(StringBuilder currentPart) {
        this.currentPart = currentPart;
    }

    @Override
    public GeneratingCorrectionI clone() {
        return new SimpleGeneratingCorrection(this, this.debugInformation != null);
    }

    public String toString() {
        return "SimpleGeneratingCorrection [firstPart=" + this.firstPart + ", secondPart=" + this.secondPart + ", separator=" + (Object)((Object)this.separator) + ", currentPart=" + this.currentPart + ", endFactor=" + this.endFactor + ", debugInformation=" + this.debugInformation + "]";
    }

    @Override
    public StringBuilder getCurrentPart() {
        return this.currentPart;
    }
}

