/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.ngram.dictionary.AbstractNGramDictionary;
import org.predict4all.nlp.ngram.trie.AbstractNGramTrieNode;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.utils.BiIntegerKey;
import org.predict4all.nlp.utils.DaemonThreadFactory;
import org.predict4all.nlp.utils.Pair;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.words.NextWord;
import org.predict4all.nlp.words.WordDictionary;
import org.predict4all.nlp.words.correction.CachedPrecomputedCorrectionRule;
import org.predict4all.nlp.words.correction.CorrectionRule;
import org.predict4all.nlp.words.correction.CorrectionRuleNode;
import org.predict4all.nlp.words.correction.CorrectionRuleNodeType;
import org.predict4all.nlp.words.correction.GeneratingCorrectionI;
import org.predict4all.nlp.words.correction.SimpleGeneratingCorrection;
import org.predict4all.nlp.words.model.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordCorrectionGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordCorrectionGenerator.class);
    private static final int[] EMPTY_ARRAY = new int[0];
    private static final int MAX_PART_COUNT = 2;
    private static final double CORRECTION_DOUBLE_MIN_LEFT_FREQUENCY = 1.0E-6;
    private final PredictionParameter predictionParameter;
    private final WordDictionary wordDictionary;
    private final AbstractNGramDictionary<? extends AbstractNGramTrieNode<?>> staticNgramDictionary;
    private final ExecutorService threadPool;
    private final Map<CorrectionRuleNode, Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule>> cachedRules;

    public WordCorrectionGenerator(WordDictionary wordDictionary, AbstractNGramDictionary<? extends AbstractNGramTrieNode<?>> staticNgramDictionary, PredictionParameter predictionParameter) {
        this.wordDictionary = wordDictionary;
        this.staticNgramDictionary = staticNgramDictionary;
        this.predictionParameter = predictionParameter;
        this.cachedRules = new HashMap<CorrectionRuleNode, Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule>>();
        this.threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());
        LOGGER.info("Correction thread pool initialized with {} core", (Object)Runtime.getRuntime().availableProcessors());
    }

    public void dispose() {
        this.threadPool.shutdown();
    }

    private Set<CachedPrecomputedCorrectionRule> getCachedPrecomputedRuleFor(PredictionParameter parameters) {
        CorrectionRuleNode correctionRulesRoot = parameters.getCorrectionRulesRoot();
        Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule> initialized = this.cachedRules.get(correctionRulesRoot);
        if (initialized == null) {
            initialized = new HashMap<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule>();
            if (correctionRulesRoot != null) {
                this.navigateRuleTreeAndGenerateCachedPrecomputedRules(initialized, correctionRulesRoot);
                LOGGER.info("Initialized {} correction rule from rule tree", (Object)initialized.size());
            }
            this.cachedRules.put(correctionRulesRoot, initialized);
        }
        return initialized.keySet();
    }

    private void navigateRuleTreeAndGenerateCachedPrecomputedRules(Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule> rules, CorrectionRuleNode node) {
        if (node.isEnabled()) {
            if (node.getType() == CorrectionRuleNodeType.LEAF) {
                this.buildAndAddTo(node.getCorrectionRule(), this.predictionParameter, rules, (previous, duplicated) -> LOGGER.debug("Duplicated rule found : {} vs {}", (Object)previous.getSrcBuilder(), (Object)duplicated.getSrcBuilder()));
            } else {
                for (CorrectionRuleNode child : node.getChildren()) {
                    this.navigateRuleTreeAndGenerateCachedPrecomputedRules(rules, child);
                }
            }
        }
    }

    public void addCorrectionsFor(String prefixRaw, Map<BiIntegerKey, NextWord> words, Set<Integer> wordIdsToExclude) {
        Set<CachedPrecomputedCorrectionRule> rules = this.getCachedPrecomputedRuleFor(this.predictionParameter);
        if (!(rules.isEmpty() || this.predictionParameter.getMinCountToProvideCorrection() > 0 && Predict4AllUtils.length(prefixRaw) < this.predictionParameter.getMinCountToProvideCorrection())) {
            long start = System.currentTimeMillis();
            String prefix = prefixRaw.toLowerCase();
            ConcurrentHashMap<String, GeneratingCorrectionI> result = new ConcurrentHashMap<String, GeneratingCorrectionI>(10000);
            LOGGER.info("Estimated number of different parallel tasks : {}", (Object)((prefix.length() + 1) * rules.size()));
            this.generateCorrection(0, 0.0, 0.0, rules, 0, new HashSet<CachedPrecomputedCorrectionRule>(100), result, new SimpleGeneratingCorrection(prefix, this.predictionParameter.isEnableDebugInformation()));
            AtomicInteger countWordSimple = new AtomicInteger(0);
            AtomicInteger countWordDouble = new AtomicInteger(0);
            HashMap biResultChecking = new HashMap();
            result.forEach((_key, rCorrection) -> {
                if (rCorrection.getPartCount() == 1) {
                    SortedMap<String, Word> wordsFromDict = this.wordDictionary.getExactWordsWithPrefixExist(rCorrection.getEndPart(0));
                    if (wordsFromDict != null && !wordsFromDict.isEmpty()) {
                        wordsFromDict.forEach((pf, word) -> {
                            BiIntegerKey key;
                            NextWord previous;
                            if (word.isValidToBePredicted(this.predictionParameter) && !wordIdsToExclude.contains(word.getID()) && ((previous = (NextWord)words.get(key = BiIntegerKey.of(word.getID()))) == null || rCorrection.getEndFactor() > previous.getFactor())) {
                                NextWord nextWord = NextWord.createUnique(word.getID(), rCorrection.getEndFactor(), true, this.predictionParameter.isEnableDebugInformation() ? new StringBuilder("Correction sans s\u00e9paration\n").append((CharSequence)rCorrection.getDebugInformation()) : null);
                                words.put(key, nextWord);
                                if (previous == null) {
                                    countWordSimple.incrementAndGet();
                                }
                            }
                        });
                    }
                } else {
                    SortedMap<String, Word> exactMatchesForRight;
                    Word exactMatchesForLeft = this.wordDictionary.getWord(rCorrection.getEndPart(0));
                    if (exactMatchesForLeft.getNGramTag() != Tag.UNKNOWN && exactMatchesForLeft.isValidToBePredicted(this.predictionParameter) && !(exactMatchesForRight = this.wordDictionary.getExactWordsWithPrefixExist(rCorrection.getEndPart(1))).isEmpty()) {
                        exactMatchesForRight.forEach((pf, wordR) -> {
                            BiIntegerKey key;
                            NextWord previous;
                            if (wordR.isValidToBePredicted(this.predictionParameter) && !wordIdsToExclude.contains(wordR.getID()) && ((previous = (NextWord)words.get(key = BiIntegerKey.of(exactMatchesForLeft.getID(), wordR.getID()))) == null || rCorrection.getEndFactor() > previous.getFactor()) && biResultChecking.computeIfAbsent(key, key_ -> this.staticNgramDictionary.getNodeForPrefix(new int[]{exactMatchesForLeft.getID(), wordR.getID()}, 0) != null).booleanValue()) {
                                NextWord nextWord = NextWord.createDouble(exactMatchesForLeft.getID(), wordR.getID(), rCorrection.getEndSeparator(0), rCorrection.getEndFactor(), true, this.predictionParameter.isEnableDebugInformation() ? new StringBuilder("Correction avec s\u00e9paration\n").append((CharSequence)rCorrection.getDebugInformation()) : null);
                                words.put(key, nextWord);
                                if (previous == null) {
                                    countWordDouble.incrementAndGet();
                                }
                            }
                        });
                    }
                }
            });
            LOGGER.info("Generate {} different modified for prefix \"{}\" in {} ms, simple = {}, double = {}", new Object[]{result.size(), prefix, System.currentTimeMillis() - start, countWordSimple.get(), countWordDouble.get()});
        }
    }

    private void generateCorrection(int ruleCount, double totalCost, double totalFactor, Collection<CachedPrecomputedCorrectionRule> rules, int previousCorrectionIndex, HashSet<CachedPrecomputedCorrectionRule> rulestoIgnore, Map<String, GeneratingCorrectionI> result, GeneratingCorrectionI currentCorrection) {
        ArrayList<Callable<Void>> tasks;
        ArrayList<Callable<Void>> arrayList = tasks = ruleCount == 0 ? new ArrayList<Callable<Void>>() : null;
        if (totalCost < this.predictionParameter.getCorrectionMaxCost() || this.predictionParameter.getCorrectionMaxCost() < 0.0) {
            for (int correctionStartIndex = previousCorrectionIndex; correctionStartIndex <= currentCorrection.getCurrentPartLength(); ++correctionStartIndex) {
                for (CachedPrecomputedCorrectionRule rule : rules) {
                    if (!this.canApplyRule(correctionStartIndex, currentCorrection, rulestoIgnore, rule)) continue;
                    if (tasks != null) {
                        int correctionStartIndexF = correctionStartIndex;
                        tasks.add(() -> {
                            this.applyCorrectionRule(ruleCount, totalCost, totalFactor, rules, correctionStartIndexF, rule, rulestoIgnore, result, currentCorrection);
                            return null;
                        });
                        continue;
                    }
                    this.applyCorrectionRule(ruleCount, totalCost, totalFactor, rules, correctionStartIndex, rule, rulestoIgnore, result, currentCorrection);
                }
            }
        }
        if (tasks != null) {
            try {
                this.threadPool.invokeAll(tasks);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't execute correction generation tasks", (Throwable)e);
            }
        }
        if (ruleCount > 0) {
            currentCorrection.endCorrection(totalFactor / ((double)ruleCount * 1.0) / totalCost);
            String key = currentCorrection.getKey();
            GeneratingCorrectionI previousCr = result.get(key);
            if (previousCr == null || previousCr.getEndFactor() < currentCorrection.getEndFactor()) {
                result.put(key, currentCorrection);
                if (this.predictionParameter.isEnableDebugInformation()) {
                    currentCorrection.getDebugInformation().append("co\u00fbt = ").append(totalCost).append(", poids = ").append(totalFactor).append(", poids final = ").append(currentCorrection.getEndFactor());
                }
            }
        }
    }

    private boolean canApplyRule(int correctionStartIndex, GeneratingCorrectionI currentCorrection, HashSet<CachedPrecomputedCorrectionRule> rulestoIgnore, CachedPrecomputedCorrectionRule rule) {
        return !(rule.getMaxIndexFromStart() >= 0 && correctionStartIndex >= rule.getMaxIndexFromStart() || rule.getMinIndexFromStart() >= 0 && correctionStartIndex < rule.getMinIndexFromStart() || rule.getMinIndexFromEnd() >= 0 && correctionStartIndex < currentCorrection.getCurrentPartLength() - rule.getMinIndexFromEnd() * Math.max(1, rule.getError().length()) || rulestoIgnore.contains(rule));
    }

    private void applyCorrectionRule(int ruleCount, double totalCost, double totalFactor, Collection<CachedPrecomputedCorrectionRule> rules, int startIndexInclusive, CachedPrecomputedCorrectionRule rule, HashSet<CachedPrecomputedCorrectionRule> toIgnore, Map<String, GeneratingCorrectionI> result, GeneratingCorrectionI currentCorrection) {
        Pair<StringBuilder, StringBuilder> prefixLeftAndRight;
        String error;
        int errorStartIndex;
        if ((this.predictionParameter.getCorrectionMaxCost() < 0.0 || rule.getCost() + totalCost < this.predictionParameter.getCorrectionMaxCost()) && (errorStartIndex = currentCorrection.indexOfInCurrentPart(error = rule.getError(), startIndexInclusive)) != -1 && (rule.getMaxIndexFromEnd() < 0 || errorStartIndex < currentCorrection.getCurrentPartLength() - rule.getMaxIndexFromEnd() * Math.max(1, rule.getError().length())) && (prefixLeftAndRight = this.checkPrefixForRuleAndGenerateParts(currentCorrection, errorStartIndex, rule)) != null) {
            boolean correctionGeneratedAnotherWords;
            String partOnRight = currentCorrection.substringInCurrentPart(errorStartIndex + error.length(), currentCorrection.getCurrentPartLength());
            GeneratingCorrectionI nCurrentCorrection = currentCorrection.clone();
            nCurrentCorrection.changeCurrentPartTo(prefixLeftAndRight.getLeft());
            boolean bl = correctionGeneratedAnotherWords = prefixLeftAndRight.getRight() != null && partOnRight.length() + prefixLeftAndRight.getRight().length() > 0;
            if (correctionGeneratedAnotherWords) {
                nCurrentCorrection.currentPartFinishedAndNewPartStarted(rule.getReplacementSeparator(), prefixLeftAndRight.getRight().append(partOnRight));
            } else {
                nCurrentCorrection.appendToCurrentPart(partOnRight);
            }
            nCurrentCorrection.appendDebugInformationForCurrentPart(currentCorrection.getCurrentPart(), prefixLeftAndRight, rule);
            int nextIndexWithReplacement = correctionGeneratedAnotherWords ? 0 : errorStartIndex + (error.length() > 0 ? rule.getReplacement().length() : 1);
            this.generateCorrection(ruleCount + 1, totalCost + rule.getCost(), totalFactor + rule.getFactor(), rules, nextIndexWithReplacement, error.length() <= 0 ? this.duplicateAndAdd(toIgnore, rule) : toIgnore, result, nCurrentCorrection);
        }
    }

    private Pair<StringBuilder, StringBuilder> checkPrefixForRuleAndGenerateParts(GeneratingCorrectionI currentCorrection, int errorStartIndex, CachedPrecomputedCorrectionRule rule) {
        String currentPartSubString = currentCorrection.substringInCurrentPart(0, errorStartIndex);
        if (rule.getReplacementSeparator() != null) {
            if (currentCorrection.getPartCount() < 2) {
                Word wordLeft;
                StringBuilder leftPart = new StringBuilder(currentPartSubString).append(rule.getReplacementLeftPart());
                boolean separatorAddedOnLeft = false;
                if (this.isSeparatorShouldBeKeptWithLeftPart(rule.getReplacementSeparator())) {
                    leftPart.append(rule.getReplacementSeparator().getOfficialChar());
                }
                if ((wordLeft = this.wordDictionary.getWord(leftPart.toString())) != null && wordLeft.getNGramTag() != Tag.UNKNOWN && this.isNotDoubleSeparatorOn(wordLeft, rule) && this.isProbabilityOfLeftWordCorrect(wordLeft)) {
                    return rule.getReplacementRightPart().length() <= 1 || !this.wordDictionary.getExactWordsWithPrefixExist(rule.getReplacementRightPart()).isEmpty() ? Pair.of(leftPart, new StringBuilder(rule.getReplacementRightPart())) : null;
                }
            }
        } else {
            StringBuilder leftPart = new StringBuilder(currentPartSubString).append(rule.getReplacement());
            return leftPart.length() <= 1 || !this.wordDictionary.getExactWordsWithPrefixExist(leftPart.toString()).isEmpty() ? Pair.of(leftPart, null) : null;
        }
        return null;
    }

    private boolean isNotDoubleSeparatorOn(Word wordLeft, CachedPrecomputedCorrectionRule rule) {
        return rule.getReplacementSeparator() == Separator.APOSTROPHE || !wordLeft.getWord().endsWith(Separator.APOSTROPHE.getOfficialCharString());
    }

    private HashSet<CachedPrecomputedCorrectionRule> duplicateAndAdd(HashSet<CachedPrecomputedCorrectionRule> toIgnore, CachedPrecomputedCorrectionRule rule) {
        HashSet<CachedPrecomputedCorrectionRule> dupl = new HashSet<CachedPrecomputedCorrectionRule>(toIgnore);
        dupl.add(rule);
        return dupl;
    }

    private boolean isSeparatorShouldBeKeptWithLeftPart(Separator separator) {
        return separator == Separator.APOSTROPHE;
    }

    private boolean isProbabilityOfLeftWordCorrect(Word word) {
        double leftWordProb = this.staticNgramDictionary.getProbability(EMPTY_ARRAY, 0, 0, word.getID());
        return leftWordProb > 1.0E-6;
    }

    private void buildAndAddTo(CorrectionRule correctionRule, PredictionParameter predictionParameter, Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule> rulesCollection) {
        this.buildAndAddTo(correctionRule, predictionParameter, rulesCollection, null);
    }

    private void buildAndAddTo(CorrectionRule correctionRule, PredictionParameter predictionParameter, Map<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule> rulesCollection, BiConsumer<CachedPrecomputedCorrectionRule, CachedPrecomputedCorrectionRule> duplicatedRuleConsumer) {
        Consumer<CachedPrecomputedCorrectionRule> adder = rule -> {
            CachedPrecomputedCorrectionRule previous = (CachedPrecomputedCorrectionRule)rulesCollection.get(rule);
            if (previous == null) {
                rulesCollection.put((CachedPrecomputedCorrectionRule)rule, (CachedPrecomputedCorrectionRule)rule);
            } else if (duplicatedRuleConsumer != null) {
                duplicatedRuleConsumer.accept(previous, (CachedPrecomputedCorrectionRule)rule);
            }
        };
        for (String error : correctionRule.getErrors()) {
            for (String replacement : correctionRule.getReplacements()) {
                if (error.equals(replacement)) continue;
                CachedPrecomputedCorrectionRule rule2 = new CachedPrecomputedCorrectionRule(correctionRule, error, replacement, Predict4AllUtils.getOrDefault(correctionRule.getFactor(), predictionParameter.getCorrectionDefaultFactor()), Predict4AllUtils.getOrDefault(correctionRule.getCost(), predictionParameter.getCorrectionDefaultCost()), Predict4AllUtils.getOrDefault(correctionRule.getMaxIndexFromStart(), -1), Predict4AllUtils.getOrDefault(correctionRule.getMinIndexFromStart(), -1), Predict4AllUtils.getOrDefault(correctionRule.getMaxIndexFromEnd(), -1), Predict4AllUtils.getOrDefault(correctionRule.getMinIndexFromEnd(), -1));
                adder.accept(rule2);
                if (!correctionRule.isBidirectional()) continue;
                adder.accept(rule2.opposite());
            }
        }
    }
}

