/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.model;

import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.words.model.Word;

public abstract class AbstractWord
implements Word {
    private final int id;

    public AbstractWord(int id) {
        this.id = id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public EquivalenceClass getEquivalenceClass() {
        return EquivalenceClass.getECById(this.getEquivalenceClassId());
    }

    @Override
    public boolean isEquivalenceClass() {
        return false;
    }

    @Override
    public byte getEquivalenceClassId() {
        return -1;
    }

    @Override
    public boolean isNGramTag() {
        return false;
    }

    @Override
    public byte getNGramTagId() {
        return -1;
    }

    @Override
    public Tag getNGramTag() {
        return Tag.getById(this.getNGramTagId());
    }

    public String toString() {
        if (this.isNGramTag()) {
            return "" + (Object)((Object)this.getNGramTag());
        }
        if (this.isEquivalenceClass()) {
            return "" + this.getEquivalenceClassId();
        }
        return this.getWord();
    }

    @Override
    public boolean isUserWord() {
        return false;
    }

    @Override
    public boolean isValidForSaving() {
        return true;
    }

    @Override
    public boolean isValidToBePredicted(PredictionParameter predictionParameter) {
        return true;
    }

    @Override
    public double getProbFactor() {
        return 1.0;
    }

    @Override
    public void setProbFactor(double factor, boolean modificationByUser) {
    }

    @Override
    public boolean isModifiedByUser() {
        return false;
    }

    @Override
    public void setModifiedByUser(boolean modified) {
    }

    @Override
    public boolean isModifiedBySystem() {
        return false;
    }

    @Override
    public void setModifiedBySystem(boolean modifiedBySystem) {
    }

    @Override
    public boolean isModifiedByUserOrSystem() {
        return false;
    }

    @Override
    public boolean isForceValid() {
        return false;
    }

    @Override
    public void setForceValid(boolean forceValid, boolean modificationByUser) {
    }

    @Override
    public boolean isForceInvalid() {
        return false;
    }

    @Override
    public void setForceInvalid(boolean forceInvalid, boolean modificationByUser) {
    }

    @Override
    public int getUsageCount() {
        return 0;
    }

    @Override
    public void incrementUsageCount() {
    }

    @Override
    public long getLastUseDate() {
        return 0L;
    }
}

