/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.model;

import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.words.model.AbstractWord;
import org.predict4all.nlp.words.model.Word;

public class SimpleWord
extends AbstractWord {
    protected final String word;
    protected double probFactor = 1.0;
    protected boolean modifiedByUser = false;
    protected boolean modifiedBySystem = false;
    protected boolean forceValid;
    protected boolean forceInvalid;

    protected SimpleWord(int id, String word) {
        super(id);
        this.word = word;
    }

    protected SimpleWord(int id, String word, boolean modifiedByUser, boolean modifiedBySystem, double probFactor, boolean forceInvalid, boolean forceValid) {
        this(id, word);
        this.modifiedByUser = modifiedByUser;
        this.modifiedBySystem = modifiedBySystem;
        this.probFactor = probFactor;
        this.forceInvalid = forceInvalid;
        this.forceValid = forceValid;
    }

    @Override
    public String getWord() {
        return this.word;
    }

    @Override
    public boolean isValidToBePredicted(PredictionParameter predictionParameter) {
        return !this.isForceInvalid();
    }

    @Override
    public double getProbFactor() {
        return this.probFactor;
    }

    @Override
    public void setProbFactor(double factor, boolean modificationByUser) {
        if (modificationByUser) {
            this.modifiedByUser |= factor != this.probFactor;
        } else {
            this.modifiedBySystem |= factor != this.probFactor;
        }
        this.probFactor = factor;
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public boolean isModifiedByUser() {
        return this.modifiedByUser;
    }

    @Override
    public boolean isModifiedBySystem() {
        return this.modifiedBySystem;
    }

    @Override
    public void setModifiedByUser(boolean modified) {
        this.modifiedByUser = modified;
    }

    @Override
    public boolean isModifiedByUserOrSystem() {
        return this.modifiedBySystem || this.modifiedByUser;
    }

    @Override
    public boolean isForceValid() {
        return this.forceValid;
    }

    @Override
    public void setForceValid(boolean forceValid, boolean modificationByUser) {
        if (modificationByUser) {
            this.modifiedByUser |= this.forceValid != forceValid;
        } else {
            this.modifiedBySystem |= this.forceValid != forceValid;
        }
        this.forceValid = forceValid;
    }

    @Override
    public boolean isForceInvalid() {
        return this.forceInvalid;
    }

    @Override
    public void setForceInvalid(boolean forceInvalid, boolean modificationByUser) {
        if (modificationByUser) {
            this.modifiedByUser |= this.forceInvalid != forceInvalid;
        } else {
            this.modifiedBySystem |= this.forceInvalid != forceInvalid;
        }
        this.forceInvalid = forceInvalid;
    }

    public static SimpleWord create(int id, String word) {
        return new SimpleWord(id, word);
    }

    public static SimpleWord createModified(int id, String word, boolean modifiedByUser, boolean modifiedBySystem, double probFactor, boolean forceInvalid, boolean forceValid) {
        return new SimpleWord(id, word, modifiedByUser, modifiedBySystem, probFactor, forceInvalid, forceValid);
    }

    @Override
    public Word clone(int newId) {
        return new SimpleWord(newId, this.word, this.modifiedByUser, this.modifiedBySystem, this.probFactor, this.forceInvalid, this.forceValid);
    }
}

