/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.words.model;

import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.words.model.SimpleWord;
import org.predict4all.nlp.words.model.Word;

public class UserWord
extends SimpleWord {
    private long updateDate;
    private int count;

    public UserWord(int id, String word) {
        super(id, word);
        this.wordUsed();
    }

    private void wordUsed() {
        this.updateDate = System.currentTimeMillis();
    }

    public UserWord(int id, String word, double probFactor, boolean forceInvalid, boolean forceValid, long updateDate, int count) {
        super(id, word, true, false, probFactor, forceInvalid, forceValid);
        this.updateDate = updateDate;
        this.count = count;
    }

    @Override
    public int getUsageCount() {
        return this.count;
    }

    @Override
    public void incrementUsageCount() {
        this.wordUsed();
        ++this.count;
    }

    @Override
    public long getLastUseDate() {
        return this.updateDate;
    }

    @Override
    public boolean isUserWord() {
        return true;
    }

    @Override
    public boolean isValidToBePredicted(PredictionParameter predictionParameter) {
        return this.isForceInvalid() ? false : (this.isForceValid() ? true : this.count >= predictionParameter.getMinUseCountToValidateNewWord());
    }

    @Override
    public String toString() {
        return this.getWord() + " [" + this.count + "]";
    }

    @Override
    public byte getType() {
        return 4;
    }

    public static UserWord create(int id, String word) {
        return new UserWord(id, word);
    }

    public static UserWord create(int id, String word, double probFactor, boolean forceInvalid, boolean forceValid, long updateDate, int count) {
        return new UserWord(id, word, probFactor, forceInvalid, forceValid, updateDate, count);
    }

    @Override
    public Word clone(int newId) {
        return new UserWord(newId, this.word, this.probFactor, this.forceInvalid, this.forceValid, this.updateDate, this.count);
    }
}

