/*
 * Decompiled with CFR 0.152.
 */
package io.mubasherusman.prayertimes;

import io.mubasherusman.prayertimes.constants.Fiqh;
import io.mubasherusman.prayertimes.constants.LatAdjMethod;
import io.mubasherusman.prayertimes.constants.Method;
import io.mubasherusman.prayertimes.constants.MidNightMode;
import io.mubasherusman.prayertimes.constants.SunProperty;
import io.mubasherusman.prayertimes.constants.TimeFormat;
import io.mubasherusman.prayertimes.constants.TimeName;
import io.mubasherusman.prayertimes.moonsighting.Fajr;
import io.mubasherusman.prayertimes.moonsighting.Isha;
import io.mubasherusman.prayertimes.moonsighting.TwilightMethod;
import io.mubasherusman.prayertimes.utils.CommonUtils;
import io.mubasherusman.prayertimes.utils.DateUtils;
import io.mubasherusman.prayertimes.utils.SunPosHelper;
import io.mubasherusman.prayertimes.utils.Trigonometry;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class PrayerTimes {
    private static final String INVALID_TIME = "-----";
    private final Double asrShadowFactor;
    private final ZonedDateTime date;
    private final Double latitude;
    private final Double longitude;
    private Method method = Method.MWL;
    private Fiqh fiqh = Fiqh.STANDARD;
    private LatAdjMethod latitudeAdjustmentMethod = LatAdjMethod.ANGLE_BASED;
    private TimeFormat timeFormat = TimeFormat.H24;
    private TwilightMethod twilightMethod = TwilightMethod.GENERAL;
    private MidNightMode midnightMode = MidNightMode.STANDARD;
    private Double elevation;
    private Map<TimeName, Integer> offset;
    private Map<TimeName, Object> customMethodParams;
    private Map<TimeName, Object> settings;
    private final Double julianDate;

    private PrayerTimes(Builder builder) {
        Objects.requireNonNull(builder, "Builder Required");
        this.date = Objects.requireNonNullElseGet(builder.date, () -> ZonedDateTime.now(ZoneId.of(Objects.requireNonNull(builder.timeZone, "Time Zone required"))));
        this.setMethod(builder);
        if (builder.fiqh != null) {
            this.fiqh = builder.fiqh;
        }
        this.asrShadowFactor = Objects.requireNonNullElseGet(builder.asarShadowFactor, this.fiqh::getId);
        this.loadSettings();
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.elevation = builder.elevation == null ? 0.0 : 1.0 * this.elevation;
        this.julianDate = DateUtils.getJulianDate(this.date.getYear(), this.date.getMonthValue(), this.date.getDayOfMonth()) - this.longitude / 360.0;
        if (builder.midnightMode != null) {
            this.midnightMode = builder.midnightMode;
        }
        if (builder.twilightMethod != null) {
            this.twilightMethod = builder.twilightMethod;
        }
        if (builder.timeFormat != null) {
            this.timeFormat = builder.timeFormat;
        }
        if (builder.latitudeAdjustmentMethod != null) {
            this.latitudeAdjustmentMethod = builder.latitudeAdjustmentMethod;
        }
        if (builder.offset != null) {
            this.offset = builder.offset;
        }
    }

    private void setMethod(Builder builder) {
        if (builder.method != null) {
            this.method = builder.method;
            if (this.method == Method.CUSTOM) {
                this.customMethodParams = this.method.getParams();
                this.customMethodParams.put(TimeName.FAJR, builder.fajarAngle);
                this.customMethodParams.put(TimeName.MAGHRIB, builder.maghribAngleOrMin);
                this.customMethodParams.put(TimeName.ISHA, builder.eshaAngleOrMin);
            }
        }
    }

    private void loadSettings() {
        this.settings = new HashMap<TimeName, Object>();
        Map<TimeName, Object> params = this.method.equals((Object)Method.CUSTOM) ? this.customMethodParams : this.method.getParams();
        this.settings.put(TimeName.IMSAK, params.get((Object)TimeName.IMSAK) != null ? params.get((Object)TimeName.IMSAK) : "10 min");
        this.settings.put(TimeName.FAJR, params.get((Object)TimeName.FAJR) != null ? params.get((Object)TimeName.FAJR) : Double.valueOf(0.0));
        this.settings.put(TimeName.ZHUHR, params.get((Object)TimeName.ZHUHR) != null ? params.get((Object)TimeName.ZHUHR) : "0 min");
        this.settings.put(TimeName.ISHA, params.get((Object)TimeName.ISHA) != null ? params.get((Object)TimeName.ISHA) : Double.valueOf(0.0));
        this.settings.put(TimeName.MAGHRIB, params.get((Object)TimeName.MAGHRIB) != null ? params.get((Object)TimeName.MAGHRIB) : "0 min");
        if (params.get((Object)TimeName.MIDNIGHT) != null) {
            this.midnightMode = (MidNightMode)((Object)params.get((Object)TimeName.MIDNIGHT));
        }
    }

    public Map<TimeName, Object> computeTimes() {
        LinkedHashMap<TimeName, Double> times = new LinkedHashMap<TimeName, Double>(){
            {
                this.put(TimeName.IMSAK, 5.0);
                this.put(TimeName.FAJR, 5.0);
                this.put(TimeName.SUNRISE, 6.0);
                this.put(TimeName.ZHUHR, 12.0);
                this.put(TimeName.ASR, 13.0);
                this.put(TimeName.SUNSET, 18.0);
                this.put(TimeName.MAGHRIB, 18.0);
                this.put(TimeName.ISHA, 18.0);
            }
        };
        this.computePrayerTimes((Map<TimeName, Double>)times);
        this.adjustTimes((Map<TimeName, Double>)times);
        double diff = Objects.equals((Object)this.midnightMode, (Object)MidNightMode.JAFARI) ? DateUtils.timeDiff((Double)times.get((Object)TimeName.SUNSET), (Double)times.get((Object)TimeName.FAJR)) : DateUtils.timeDiff((Double)times.get((Object)TimeName.SUNSET), (Double)times.get((Object)TimeName.SUNRISE));
        times.put(TimeName.MIDNIGHT, (Double)times.get((Object)TimeName.SUNSET) + diff / 2.0);
        times.put(TimeName.FIRST_THIRD, (Double)times.get((Object)TimeName.SUNSET) + diff / 3.0);
        times.put(TimeName.LAST_THIRD, (Double)times.get((Object)TimeName.SUNSET) + 2.0 * (diff / 3.0));
        if (Objects.equals((Object)this.method, (Object)Method.MOONSIGHTING)) {
            this.moonSightingRecalculation((Map<TimeName, Double>)times);
        }
        this.tuneTimes((Map<TimeName, Double>)times);
        return this.modifyFormats((Map<TimeName, Double>)times);
    }

    private void computePrayerTimes(Map<TimeName, Double> times) {
        this.dayPortion(times);
        times.put(TimeName.IMSAK, this.sunAngleTime(CommonUtils.evaluate(this.settings.get((Object)TimeName.IMSAK)), times.get((Object)TimeName.IMSAK), "ccw"));
        times.put(TimeName.SUNRISE, this.sunAngleTime(SunPosHelper.sunRiseAngle(this.elevation), times.get((Object)TimeName.SUNRISE), "ccw"));
        times.put(TimeName.FAJR, this.sunAngleTime(CommonUtils.evaluate(this.settings.get((Object)TimeName.FAJR)), times.get((Object)TimeName.FAJR), "ccw"));
        times.put(TimeName.ZHUHR, this.midDay(times.get((Object)TimeName.ZHUHR)));
        times.put(TimeName.ASR, this.asrTime(this.asrShadowFactor, times.get((Object)TimeName.ASR)));
        times.put(TimeName.SUNSET, this.sunAngleTime(SunPosHelper.sunRiseAngle(this.elevation), times.get((Object)TimeName.SUNSET)));
        times.put(TimeName.MAGHRIB, this.sunAngleTime(CommonUtils.evaluate(this.settings.get((Object)TimeName.MAGHRIB)), times.get((Object)TimeName.MAGHRIB)));
        times.put(TimeName.ISHA, this.sunAngleTime(CommonUtils.evaluate(this.settings.get((Object)TimeName.ISHA)), times.get((Object)TimeName.ISHA)));
    }

    private void adjustTimes(Map<TimeName, Double> times) {
        ZoneId dateTimeZone = this.date.getZone();
        for (Map.Entry<TimeName, Double> entry : times.entrySet()) {
            TimeName key = entry.getKey();
            Double value = entry.getValue();
            times.put(key, value + (double)(dateTimeZone.getRules().getOffset(this.date.toInstant()).getTotalSeconds() / 3600) - this.longitude / 15.0);
        }
        if (!this.latitudeAdjustmentMethod.equals((Object)LatAdjMethod.NONE)) {
            this.adjustHighLatitudes(times);
        }
        if (CommonUtils.containsMin(this.settings.get((Object)TimeName.IMSAK))) {
            times.put(TimeName.IMSAK, times.get((Object)TimeName.FAJR) - CommonUtils.evaluate(this.settings.get((Object)TimeName.IMSAK)) / 60.0);
        }
        if (CommonUtils.containsMin(this.settings.get((Object)TimeName.MAGHRIB))) {
            times.put(TimeName.MAGHRIB, times.get((Object)TimeName.SUNSET) + CommonUtils.evaluate(this.settings.get((Object)TimeName.MAGHRIB)) / 60.0);
        }
        if (CommonUtils.containsMin(this.settings.get((Object)TimeName.ISHA))) {
            times.put(TimeName.ISHA, times.get((Object)TimeName.MAGHRIB) + CommonUtils.evaluate(this.settings.get((Object)TimeName.ISHA)) / 60.0);
        }
        times.put(TimeName.ZHUHR, times.get((Object)TimeName.ZHUHR) + CommonUtils.evaluate(this.settings.get((Object)TimeName.ZHUHR)) / 60.0);
    }

    private void moonSightingRecalculation(Map<TimeName, Double> times) {
        Fajr fajrMS = new Fajr(this.date, this.latitude);
        times.put(TimeName.FAJR, times.get((Object)TimeName.SUNRISE) - fajrMS.getMinutesBeforeSunrise() / 60.0);
        if (CommonUtils.containsMin(this.settings.get((Object)TimeName.IMSAK))) {
            times.put(TimeName.IMSAK, times.get((Object)TimeName.FAJR) - CommonUtils.evaluate(this.settings.get((Object)TimeName.IMSAK)) / 60.0);
        }
        Isha ishaMS = new Isha(this.date, this.latitude, this.twilightMethod);
        times.put(TimeName.ISHA, times.get((Object)TimeName.SUNSET) + (double)(ishaMS.getMinutesAfterSunset() / 60.0f));
    }

    private void tuneTimes(Map<TimeName, Double> times) {
        if (this.offset != null && !this.offset.isEmpty()) {
            for (Map.Entry<TimeName, Integer> entry : this.offset.entrySet()) {
                Integer value = entry.getValue();
                times.computeIfPresent(entry.getKey(), (k, v) -> v + (double)(value / 60));
            }
        }
    }

    private Map<TimeName, Object> modifyFormats(Map<TimeName, Double> times) {
        LinkedHashMap<TimeName, Object> modifiedTimes = new LinkedHashMap<TimeName, Object>();
        for (Map.Entry<TimeName, Double> entry : times.entrySet()) {
            TimeName key = entry.getKey();
            Double value = entry.getValue();
            modifiedTimes.put(key, this.getFormattedTime(value, key));
        }
        return modifiedTimes;
    }

    private Object getFormattedTime(double time, TimeName prayer) {
        if (Double.isNaN(time)) {
            return INVALID_TIME;
        }
        if (this.timeFormat.equals((Object)TimeFormat.DECIMAL)) {
            return time;
        }
        String[] suffixes = new String[]{"AM", "PM"};
        time = Trigonometry.fixHour(time + 0.008333333333333333);
        int hours = (int)Math.floor(time);
        int minutes = (int)Math.floor((time - (double)hours) * 60.0);
        String suffix = this.timeFormat.equals((Object)TimeFormat.H12) ? suffixes[hours < 12 ? 0 : 1] : "";
        int hour = this.timeFormat.equals((Object)TimeFormat.H24) ? hours : (hours + 12 - 1) % 12 + 1;
        String twoDigitHour = CommonUtils.twoDigitsFormat(hour);
        String twoDigitMinutes = CommonUtils.twoDigitsFormat(minutes);
        if (this.timeFormat.equals((Object)TimeFormat.ISO8601)) {
            ZonedDateTime tempDate = this.date.withHour(hours).withMinute(minutes);
            if (prayer.equals((Object)TimeName.MIDNIGHT) && hours >= 1 && hours < 12) {
                tempDate = tempDate.plusDays(1L);
            }
            return tempDate.toString();
        }
        return twoDigitHour + ":" + twoDigitMinutes + (String)(suffix.isEmpty() ? "" : " " + suffix);
    }

    private void adjustHighLatitudes(Map<TimeName, Double> times) {
        double nightTime = DateUtils.timeDiff(times.get((Object)TimeName.SUNSET), times.get((Object)TimeName.SUNRISE));
        times.put(TimeName.IMSAK, this.adjustHLTime(times.get((Object)TimeName.IMSAK), times.get((Object)TimeName.SUNRISE), CommonUtils.evaluate(this.settings.get((Object)TimeName.IMSAK)), nightTime, "ccw"));
        times.put(TimeName.FAJR, this.adjustHLTime(times.get((Object)TimeName.FAJR), times.get((Object)TimeName.SUNRISE), CommonUtils.evaluate(this.settings.get((Object)TimeName.FAJR)), nightTime, "ccw"));
        times.put(TimeName.ISHA, this.adjustHLTime(times.get((Object)TimeName.ISHA), times.get((Object)TimeName.SUNSET), CommonUtils.evaluate(this.settings.get((Object)TimeName.ISHA)), nightTime));
        times.put(TimeName.MAGHRIB, this.adjustHLTime(times.get((Object)TimeName.MAGHRIB), times.get((Object)TimeName.SUNSET), CommonUtils.evaluate(this.settings.get((Object)TimeName.MAGHRIB)), nightTime));
    }

    private double adjustHLTime(double time, double base, double angle, double night) {
        return this.adjustHLTime(time, base, angle, night, null);
    }

    private double adjustHLTime(double time, double base, double angle, double night, String direction) {
        double timeDiff;
        double portion = this.nightPortion(angle, night);
        double d = timeDiff = "ccw".equals(direction) ? DateUtils.timeDiff(time, base) : DateUtils.timeDiff(base, time);
        if (Double.isNaN(time) || timeDiff > portion) {
            time = base + ("ccw".equals(direction) ? -portion : portion);
        }
        return time;
    }

    private double nightPortion(double angle, double night) {
        double portion;
        if (this.latitudeAdjustmentMethod.equals((Object)LatAdjMethod.ANGLE_BASED)) {
            portion = 0.016666666666666666 * angle;
        } else if (this.latitudeAdjustmentMethod.equals((Object)LatAdjMethod.ONE_SEVENTH)) {
            portion = 0.14285714285714285;
        } else if (this.latitudeAdjustmentMethod.equals((Object)LatAdjMethod.MIDDLE_OF_THE_NIGHT)) {
            portion = 0.5;
        } else {
            throw new IllegalArgumentException("Value of latitudeAdjustmentMethod in invalid");
        }
        return portion * night;
    }

    private double sunAngleTime(double angle, double time) {
        return this.sunAngleTime(angle, time, null);
    }

    private double sunAngleTime(double angle, double time, String direction) {
        double p2;
        double decl = SunPosHelper.sunPosition(this.julianDate + time).get((Object)SunProperty.DECLINATION);
        double noon = this.midDay(time);
        double p1 = -Trigonometry.sin(angle) - Trigonometry.sin(decl) * Trigonometry.sin(this.latitude);
        double cosRange = p1 / (p2 = Trigonometry.cos(decl) * Trigonometry.cos(this.latitude));
        if (cosRange > 1.0) {
            cosRange = 1.0;
        }
        if (cosRange < -1.0) {
            cosRange = -1.0;
        }
        double t = 0.06666666666666667 * Trigonometry.arccos(cosRange);
        return noon + (direction != null && direction.equals("ccw") ? -t : t);
    }

    private double asrTime(double factor, double time) {
        double decl = SunPosHelper.sunPosition(this.julianDate + time).get((Object)SunProperty.DECLINATION);
        double angle = -Trigonometry.arccot(factor + Trigonometry.tan(Math.abs(this.latitude - decl)));
        return this.sunAngleTime(angle, time);
    }

    private double midDay(double time) {
        double eqt = SunPosHelper.sunPosition(this.julianDate + time).get((Object)SunProperty.EQUATION_OF_TIME);
        return Trigonometry.fixHour(12.0 - eqt);
    }

    private void dayPortion(Map<TimeName, Double> times) {
        times.replaceAll((k, v) -> v / 24.0);
    }

    public Map<String, Object> getMeta() {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("latitude", PrayerTimes.this.latitude);
                this.put("longitude", PrayerTimes.this.longitude);
                this.put("timezone", PrayerTimes.this.date.format(DateTimeFormatter.ofPattern("zzz", Locale.forLanguageTag("en"))));
                if (Objects.equals((Object)PrayerTimes.this.method, (Object)Method.MOONSIGHTING)) {
                    this.put("latitudeAdjustmentMethod", LatAdjMethod.NONE);
                    PrayerTimes.this.method.getParams().put(TimeName.SHAFAQ, (Object)PrayerTimes.this.twilightMethod);
                } else {
                    this.put("latitudeAdjustmentMethod", PrayerTimes.this.latitudeAdjustmentMethod);
                }
                this.put("method", PrayerTimes.this.method);
                this.put("midnightMode", PrayerTimes.this.midnightMode);
                this.put("school", PrayerTimes.this.fiqh);
                this.put("offset", PrayerTimes.this.offset);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double latitude;
        private double longitude;
        private ZonedDateTime date;
        private String timeZone;
        private Method method;
        private Fiqh fiqh;
        private Double asarShadowFactor;
        private TimeFormat timeFormat;
        private TwilightMethod twilightMethod;
        private LatAdjMethod latitudeAdjustmentMethod;
        private MidNightMode midnightMode;
        private Map<TimeName, Integer> offset;
        private Double elevation;
        private Float fajarAngle;
        private Object maghribAngleOrMin;
        private Object eshaAngleOrMin;

        private Builder() {
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder date(ZonedDateTime date) {
            this.date = date;
            return this;
        }

        public Builder timezone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder fiqh(Fiqh fiqh) {
            this.fiqh = fiqh;
            return this;
        }

        public Builder asarShadowFactor(Double asarShadowFactor) {
            this.asarShadowFactor = asarShadowFactor;
            return this;
        }

        public Builder timeFormat(TimeFormat timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder twilightMethod(TwilightMethod twilightMethod) {
            this.twilightMethod = twilightMethod;
            return this;
        }

        public Builder latitudeAdjustmentMethod(LatAdjMethod latitudeAdjustmentMethod) {
            this.latitudeAdjustmentMethod = latitudeAdjustmentMethod;
            return this;
        }

        public Builder midnightMode(MidNightMode midnightMode) {
            this.midnightMode = midnightMode;
            return this;
        }

        public Builder elevation(Double elevation) {
            this.elevation = elevation;
            return this;
        }

        public void setCustomMethod(Float fajarAngle, Object maghribAngleOrMin, Object eshaAngleOrMin) {
            this.method = Method.CUSTOM;
            this.fajarAngle = fajarAngle;
            this.maghribAngleOrMin = maghribAngleOrMin;
            this.eshaAngleOrMin = eshaAngleOrMin;
        }

        public void setOffset(final int imsak, final int fajr, final int sunrise, final int dhuhr, final int asr, final int maghrib, final int sunset, final int isha, final int midnight) {
            this.offset = new HashMap<TimeName, Integer>(){
                {
                    this.put(TimeName.IMSAK, imsak);
                    this.put(TimeName.FAJR, fajr);
                    this.put(TimeName.SUNRISE, sunrise);
                    this.put(TimeName.ZHUHR, dhuhr);
                    this.put(TimeName.ASR, asr);
                    this.put(TimeName.MAGHRIB, maghrib);
                    this.put(TimeName.SUNSET, sunset);
                    this.put(TimeName.ISHA, isha);
                    this.put(TimeName.MIDNIGHT, midnight);
                }
            };
        }

        public PrayerTimes build() {
            return new PrayerTimes(this);
        }
    }
}

