/*
 * Decompiled with CFR 0.152.
 */
package io.mubasherusman.prayertimes.constants;

import io.mubasherusman.prayertimes.constants.MidNightMode;
import io.mubasherusman.prayertimes.constants.TimeName;
import io.mubasherusman.prayertimes.moonsighting.TwilightMethod;
import java.util.HashMap;
import java.util.Map;

public enum Method {
    JAFARI(0, "Shia Ithna-Ashari, Leva Institute, Qum", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 16.0);
            this.put(TimeName.ISHA, 14.0);
            this.put(TimeName.MAGHRIB, 4.0);
            this.put(TimeName.MIDNIGHT, MidNightMode.JAFARI);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 34.6415764);
            this.put("longitude", 50.8746035);
        }
    }),
    KARACHI(1, "University of Islamic Sciences, Karachi", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 24.8614622);
            this.put("longitude", 67.0099388);
        }
    }),
    ISNA(2, "Islamic Society of North America (ISNA)", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 15.0);
            this.put(TimeName.ISHA, 15.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 39.70421229999999);
            this.put("longitude", -86.39943869999999);
        }
    }),
    MWL(3, "Muslim World League", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 17.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 51.5194682);
            this.put("longitude", -0.1360365);
        }
    }),
    MAKKAH(4, "Umm Al-Qura University, Makkah", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.5);
            this.put(TimeName.ISHA, "90 min");
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 21.3890824);
            this.put("longitude", 39.8579118);
        }
    }),
    EGYPT(5, "Egyptian General Authority of Survey", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 19.5);
            this.put(TimeName.ISHA, 17.5);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 30.0444196);
            this.put("longitude", 31.2357116);
        }
    }),
    TEHRAN(7, "Institute of Geophysics, University of Tehran", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 17.7);
            this.put(TimeName.ISHA, 14.0);
            this.put(TimeName.MAGHRIB, 4.5);
            this.put(TimeName.MIDNIGHT, MidNightMode.JAFARI);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 35.6891975);
            this.put("longitude", 51.3889736);
        }
    }),
    GULF(8, "Gulf Region", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 19.5);
            this.put(TimeName.ISHA, "90 min");
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 24.1323638);
            this.put("longitude", 53.3199527);
        }
    }),
    KUWAIT(9, "Kuwait", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 17.5);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 29.375859);
            this.put("longitude", 47.9774052);
        }
    }),
    QATAR(10, "Qatar", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, "90 min");
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 25.2854473);
            this.put("longitude", 51.5310398);
        }
    }),
    SINGAPORE(11, "Majlis Ugama Islam Singapura, Singapore", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 20.0);
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 1.352083);
            this.put("longitude", 103.819836);
        }
    }),
    FRANCE(12, "Union Organization Islamic de France", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 12.0);
            this.put(TimeName.ISHA, 12.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 48.856614);
            this.put("longitude", 2.3522219);
        }
    }),
    TURKEY(13, "Diyanet \u0130\u015fleri Ba\u015fkanl\u0131\u011f\u0131, Turkey (experimental)", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 17.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 39.9333635);
            this.put("longitude", 32.8597419);
        }
    }),
    RUSSIA(14, "Spiritual Administration of Muslims of Russia", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 16.0);
            this.put(TimeName.ISHA, 15.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 54.73479099999999);
            this.put("longitude", 55.9578555);
        }
    }),
    MOONSIGHTING(15, "Moonsighting Committee Worldwide (Moonsighting.com)", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.SHAFAQ, TwilightMethod.GENERAL);
        }
    }, null),
    DUBAI(16, "Dubai (experimental)", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.2);
            this.put(TimeName.ISHA, 18.2);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 25.0762677);
            this.put("longitude", 55.087404);
        }
    }),
    JAKIM(17, "Jabatan Kemajuan Islam Malaysia (JAKIM)", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 20.0);
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 3.139003);
            this.put("longitude", 101.686855);
        }
    }),
    TUNISIA(18, "Tunisia", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 36.8064948);
            this.put("longitude", 10.1815316);
        }
    }),
    ALGERIA(19, "Algeria", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.ISHA, 17.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 36.753768);
            this.put("longitude", 3.0587561);
        }
    }),
    KEMENAG(20, "Kementerian Agama Republik Indonesia", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 20.0);
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", -6.2087634);
            this.put("longitude", 106.845599);
        }
    }),
    MOROCCO(21, "Morocco", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 19.0);
            this.put(TimeName.ISHA, 17.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 33.9715904);
            this.put("longitude", -6.8498129);
        }
    }),
    PORTUGAL(22, "Comunidade Islamica de Lisboa", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.MAGHRIB, "3 min");
            this.put(TimeName.ISHA, "77 min");
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 38.7222524);
            this.put("longitude", -9.1393366);
        }
    }),
    JORDAN(23, "Ministry of Awqaf, Islamic Affairs and Holy Places, Jordan", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 18.0);
            this.put(TimeName.MAGHRIB, "5 min");
            this.put(TimeName.ISHA, 18.0);
        }
    }, (Map<String, Double>)new HashMap<String, Double>(){
        {
            this.put("latitude", 31.9461222);
            this.put("longitude", 35.923844);
        }
    }),
    CUSTOM(99, "Custom", (Map<TimeName, Object>)new HashMap<TimeName, Object>(){
        {
            this.put(TimeName.FAJR, 15.0);
            this.put(TimeName.ISHA, 15.0);
        }
    }, null);

    private Integer id;
    private String name;
    private Map<TimeName, Object> params;
    private Map<String, Double> location;

    private Method(Integer id, String name, Map<TimeName, Object> params, Map<String, Double> location) {
        this.id = id;
        this.name = name;
        this.params = params;
        this.location = location;
    }

    public void setFajrAngle(Object angle) {
        this.params.put(TimeName.FAJR, angle);
    }

    public void setMaghribAngleOrMins(Object angleOrMinsAfterSunset) {
        this.params.put(TimeName.MAGHRIB, angleOrMinsAfterSunset);
    }

    public void setIshaAngleOrMins(Object angleOrMinsAfterMaghrib) {
        this.params.put(TimeName.ISHA, angleOrMinsAfterMaghrib);
    }

    public Map<TimeName, Object> getParams() {
        return this.equals((Object)CUSTOM) || this.equals((Object)MOONSIGHTING) ? new HashMap<TimeName, Object>(this.params) : Map.copyOf(this.params);
    }
}

