/*
 * Decompiled with CFR 0.152.
 */
package io.mubasherusman.prayertimes.moonsighting;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class Prayer {
    double latitude;
    private final ZonedDateTime date;
    double a;
    double b;
    double c;
    double d;
    private int dyy;
    private static final String DYY_NORTH_0 = "12-21";
    private static final String DYY_SOUTH_0 = "06-21";

    public Prayer(ZonedDateTime date, double latitude) {
        this.date = date;
        this.latitude = latitude;
        this.getDyy();
    }

    public void getDyy() {
        int year = this.date.getYear();
        LocalDate dateDyyZero = this.latitude > 0.0 ? LocalDate.parse(year + "-12-21") : LocalDate.parse(year + "-06-21");
        long diff = ChronoUnit.DAYS.between(dateDyyZero, this.date);
        this.dyy = diff > 0L ? (int)diff : 365 + (int)diff;
    }

    protected double getMinutes() {
        if (this.dyy < 91) {
            return this.a + (this.b - this.a) / 91.0 * (double)this.dyy;
        }
        if (this.dyy < 137) {
            return this.b + (this.c - this.b) / 46.0 * (double)(this.dyy - 91);
        }
        if (this.dyy < 183) {
            return this.c + (this.d - this.c) / 46.0 * (double)(this.dyy - 137);
        }
        if (this.dyy < 229) {
            return this.d + (this.c - this.d) / 46.0 * (double)(this.dyy - 183);
        }
        if (this.dyy < 275) {
            return this.c + (this.b - this.c) / 46.0 * (double)(this.dyy - 229);
        }
        return this.b + (this.a - this.b) / 91.0 * (double)(this.dyy - 275);
    }
}

