/*
 * Decompiled with CFR 0.152.
 */
package io.mubasherusman.prayertimes.utils;

import io.mubasherusman.prayertimes.constants.SunProperty;
import io.mubasherusman.prayertimes.utils.Trigonometry;
import java.util.HashMap;
import java.util.Map;

public class SunPosHelper {
    public static Map<SunProperty, Double> sunPosition(double julianDate) {
        double D = julianDate - 2451545.0;
        double g = Trigonometry.fixAngle(357.529 + 0.98560028 * D);
        double q = Trigonometry.fixAngle(280.459 + 0.98564736 * D);
        double L = Trigonometry.fixAngle(q + 1.915 * Trigonometry.sin(g) + 0.02 * Trigonometry.sin(2.0 * g));
        double e = 23.439 - 3.6E-7 * D;
        double RA = Trigonometry.arctan2(Trigonometry.cos(e) * Trigonometry.sin(L), Trigonometry.cos(L)) / 15.0;
        final double eqt = q / 15.0 - Trigonometry.fixHour(RA);
        final double decl = Trigonometry.arcsin(Trigonometry.sin(e) * Trigonometry.sin(L));
        return new HashMap<SunProperty, Double>(){
            {
                this.put(SunProperty.EQUATION_OF_TIME, eqt);
                this.put(SunProperty.DECLINATION, decl);
            }
        };
    }

    public static double sunRiseAngle(double elevation) {
        double angle = 0.0347 * Math.sqrt(elevation);
        return 0.833 + angle;
    }
}

