/*
 * Decompiled with CFR 0.152.
 */
package ch.bluecare.commons.data;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class PList<E>
implements Iterable<E>,
IntFunction<E> {
    private PList() {
    }

    public static <A> PList<A> nil() {
        return Nil.INSTANCE;
    }

    public static <A> PList<A> empty() {
        return PList.nil();
    }

    public static <A> PList<A> cell(A head, PList<A> tail) {
        return new Cons(head, tail, tail.size() + 1);
    }

    public static <A> PList<A> single(A element) {
        return PList.cell(element, PList.nil());
    }

    public static <A> PList<A> fromNullable(A element) {
        return element == null ? PList.nil() : PList.single(element);
    }

    public static <A, B> PList<B> generate(A init, Function<A, Optional<Pair<A, B>>> next) {
        Optional<Pair<A, B>> el = next.apply(init);
        PList<A> list = PList.nil();
        while (el.isPresent()) {
            list = list.cons(el.get().second());
            el = next.apply(el.get().first());
        }
        return list;
    }

    @SafeVarargs
    public static <A> PList<A> of(A ... elements) {
        return PList.fromArray(elements);
    }

    public static <A> PList<A> fill(Supplier<A> supplier, int length) {
        return PList.generate(0, n -> n < length ? Optional.of(Pair.of(n + 1, supplier.get())) : Optional.empty());
    }

    public static PList<Integer> range(int start, int end) {
        return PList.generate(end - 1, n -> n >= start ? Optional.of(Pair.of(n - 1, n)) : Optional.empty());
    }

    public static <A> PList<A> fromIter(Iterable<A> iter) {
        if (iter instanceof PList) {
            return (PList)iter;
        }
        return iter == null ? PList.nil() : PList.collect(iter.iterator());
    }

    public static <A> PList<A> fromOptional(Optional<A> opt) {
        return opt.map(PList::single).orElseGet(PList::nil);
    }

    public static <A> PList<A> fromArray(A[] values) {
        if (values == null) {
            return PList.nil();
        }
        return PList.generate(0, n -> n < values.length ? Optional.of(Pair.of(n + 1, values[n])) : Optional.empty()).reverse();
    }

    public static <A> PList<A> collect(Iterator<A> iter) {
        if (iter == null) {
            return PList.nil();
        }
        return PList.generate(iter.hasNext(), b -> b != false ? Optional.of(Pair.swapped(iter.next(), iter.hasNext())) : Optional.empty()).reverse();
    }

    public static <T> Collector<T, ?, PList<T>> collector() {
        return Collectors.reducing(PList.nil(), PList::single, PList::concat);
    }

    public abstract int size();

    public abstract PList<E> tail();

    public abstract E head();

    public abstract boolean isEmpty();

    @Override
    public E apply(int index) {
        AtomicInteger idx = new AtomicInteger(index);
        Optional<Object> el = this.find(e -> {
            if (idx.get() == 0) {
                return true;
            }
            idx.set(idx.get() - 1);
            return false;
        });
        return (E)el.orElseThrow(() -> new IndexOutOfBoundsException("index: " + index));
    }

    public Function<Integer, E> asFunction() {
        return index -> {
            Objects.requireNonNull(index, "index must not be null");
            return this.apply((int)index);
        };
    }

    public PList<E> concat(PList<E> next) {
        return this.foldRight(next, PList::cons);
    }

    public final PList<E> cons(E element) {
        return PList.cell(element, this);
    }

    public PList<E> add(E element) {
        return this.concat(PList.single(element));
    }

    public boolean contains(E element, BiPredicate<E, E> eq) {
        return this.indexOf(element, eq) != -1;
    }

    public final PList<E> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be positive");
        }
        PList<E> result = this;
        for (int i = 0; i < count; ++i) {
            if (!result.nonEmpty()) continue;
            result = result.tail();
        }
        return result;
    }

    public final PList<E> dropRight(int count) {
        int len = this.size();
        return count >= len ? PList.nil() : this.take(len - count);
    }

    public boolean exists(Predicate<E> predicate) {
        return this.find(predicate).isPresent();
    }

    public PList<E> filter(Predicate<E> filter) {
        return this.flatMap(e -> filter.test(e) ? Collections.singletonList(e) : Collections.emptyList());
    }

    private PList<E> filterWith(BiPredicate<E, E> filter, Predicate<E> last) {
        return (PList)this.foldLeft(Pair.of(this.drop(1), PList.nil()), (p, e) -> {
            Predicate pred = ((PList)p.first()).headOption().map((? super T next) -> x -> filter.test(x, next)).orElse(last);
            return pred.test(e) ? Pair.of(((PList)p.first()).drop(1), ((PList)p.second()).cons(e)) : Pair.of(((PList)p.first()).drop(1), (PList)p.second());
        }).second();
    }

    public PList<E> filterWithNext(BiPredicate<E, E> filter, Predicate<E> last) {
        return this.filterWith(filter, last).reverse();
    }

    public PList<E> filterWithPrev(Predicate<E> first, BiPredicate<E, E> filter) {
        return super.filterWith((a, b) -> filter.test(b, a), first);
    }

    public PList<E> distinct(Comparator<E> comparator) {
        return this.sort(comparator).filterWithNext((e1, e2) -> comparator.compare(e1, e2) != 0, ign -> true);
    }

    public <T> PList<E> distinct(Function<E, T> getKey) {
        HashSet seen = new HashSet();
        Predicate<Object> distinctFilter = e -> seen.add(getKey.apply(e));
        return this.filter(distinctFilter);
    }

    public PList<E> duplicates(Comparator<E> comparator) {
        return this.sort(comparator).filterWithNext((e1, e2) -> comparator.compare(e1, e2) == 0, ign -> false).filterWithNext((e1, e2) -> comparator.compare(e1, e2) != 0, ign -> true);
    }

    public Optional<E> find(Predicate<E> predicate) {
        PList<E> current = this;
        while (current.nonEmpty()) {
            if (predicate.test(current.head())) {
                return Optional.of(current.head());
            }
            current = current.tail();
        }
        return Optional.empty();
    }

    public <B> PList<B> flatMap(Function<E, Iterable<B>> f) {
        PList result = PList.nil();
        PList<E> current = this;
        while (current.nonEmpty()) {
            Iterable<B> bs = f.apply(current.head());
            for (B b : bs) {
                result = result.cons(b);
            }
            current = current.tail();
        }
        return result.reverse();
    }

    public <B> PList<B> flatMapOptional(Function<E, Optional<B>> f) {
        return this.flatMap(e -> PList.fromOptional((Optional)f.apply(e)));
    }

    public boolean forall(Predicate<E> predicate) {
        return !this.find(predicate.negate()).isPresent();
    }

    public <B> B foldLeft(B init, BiFunction<B, E, B> f) {
        B result = init;
        PList<E> list = this;
        while (list.nonEmpty()) {
            result = f.apply(result, list.head());
            list = list.tail();
        }
        return result;
    }

    public <B> B foldRight(B init, BiFunction<B, E, B> f) {
        return this.reverse().foldLeft(init, f);
    }

    public <K> Map<K, NonEmptyList<E>> groupBy(Function<E, K> f) {
        HashMap result = new HashMap();
        this.forEach(e -> {
            Object key = f.apply(e);
            NonEmptyList g = (NonEmptyList)result.get(key);
            if (g == null) {
                result.put(key, NonEmptyList.single(e));
            } else {
                result.put(key, g.cons(e));
            }
        });
        return result;
    }

    public final Optional<E> headOption() {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(this.head());
    }

    public int indexOf(E element, BiPredicate<E, E> eq) {
        AtomicInteger index = new AtomicInteger(0);
        Optional<Object> found = this.find(el -> {
            boolean r = eq.test(element, el);
            if (!r) {
                index.incrementAndGet();
            }
            return r;
        });
        return found.isPresent() ? index.get() : -1;
    }

    public PList<Integer> indexesOf(E element, BiPredicate<E, E> eq) {
        return this.zipWithIndex().filter(p -> eq.test(p.first(), element)).map(Pair::second);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private PList<E> current;
            {
                this.current = PList.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != PList.nil();
            }

            @Override
            public E next() {
                Object next = this.current.head();
                this.current = this.current.tail();
                return next;
            }
        };
    }

    public <B> PList<B> map(Function<E, B> f) {
        return this.flatMap(e -> Collections.singleton(f.apply(e)));
    }

    public Optional<E> max(Comparator<E> comparator) {
        return this.reduce((e1, e2) -> comparator.compare(e1, e2) < 0 ? e2 : e1);
    }

    public Optional<E> min(Comparator<E> comparator) {
        return this.reduce((e1, e2) -> comparator.compare(e1, e2) < 0 ? e1 : e2);
    }

    public String mkString(String sep) {
        StringBuilder buffer = new StringBuilder();
        this.forEach(el -> {
            if (buffer.length() != 0) {
                buffer.append(sep);
            }
            buffer.append(el);
        });
        return buffer.toString();
    }

    public final boolean nonEmpty() {
        return !this.isEmpty();
    }

    public Optional<E> reduce(BinaryOperator<E> f) {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.tail().foldLeft(this.head(), f));
    }

    public PList<E> reverse() {
        return this.foldLeft(PList.nil(), PList::cons);
    }

    public final PList<E> take(int count) {
        int len = this.size();
        if (count >= len) {
            return this;
        }
        PList result = PList.nil();
        PList<E> current = this;
        for (int i = 0; i < count; ++i) {
            result = result.cons(current.head());
            current = current.tail();
        }
        return result.reverse();
    }

    public final PList<E> takeRight(int count) {
        int len = this.size();
        return count >= len ? this : this.drop(len - count);
    }

    public PList<E> sort(Comparator<E> comparator) {
        List<E> jl = this.toArrayList();
        jl.sort(comparator);
        return PList.fromIter(jl);
    }

    public List<E> toArrayList() {
        ArrayList result = new ArrayList();
        this.forEach(result::add);
        return result;
    }

    public E[] toArray(Class<E> type) {
        Object[] array = (Object[])Array.newInstance(type, this.size());
        AtomicInteger index = new AtomicInteger(0);
        this.forEach(el -> {
            array[index.getAndIncrement()] = el;
        });
        return array;
    }

    public static byte[] toByteArray(PList<Byte> list) {
        byte[] result = new byte[list.size()];
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(el -> {
            result[index.getAndIncrement()] = el;
        });
        return result;
    }

    public static int[] toIntArray(PList<Integer> list) {
        int[] result = new int[list.size()];
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(el -> {
            result[index.getAndIncrement()] = el;
        });
        return result;
    }

    public static long[] toLongArray(PList<Integer> list) {
        long[] result = new long[list.size()];
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(el -> {
            result[index.getAndIncrement()] = el.intValue();
        });
        return result;
    }

    public static float[] toFloatArray(PList<Integer> list) {
        float[] result = new float[list.size()];
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(el -> {
            result[index.getAndIncrement()] = el.intValue();
        });
        return result;
    }

    public static double[] toDoubleArray(PList<Integer> list) {
        double[] result = new double[list.size()];
        AtomicInteger index = new AtomicInteger(0);
        list.forEach(el -> {
            result[index.getAndIncrement()] = el.intValue();
        });
        return result;
    }

    public Set<E> toHashSet() {
        HashSet set = new HashSet();
        this.forEach(set::add);
        return set;
    }

    public Stream<E> toStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1024), false);
    }

    public <B> Iterable<Pair<E, B>> zipLazy(final Iterable<B> other) {
        return () -> new Iterator<Pair<E, B>>(){
            private final Iterator<E> thisIter;
            private final Iterator<B> otherIter;
            {
                this.thisIter = PList.this.iterator();
                this.otherIter = other.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.thisIter.hasNext() && this.otherIter.hasNext();
            }

            @Override
            public Pair<E, B> next() {
                return Pair.of(this.thisIter.next(), this.otherIter.next());
            }
        };
    }

    public <A> PList<Pair<E, A>> zip(Iterable<A> other) {
        return PList.fromIter(this.zipLazy(other));
    }

    public PList<Pair<E, Integer>> zipWithIndex() {
        AtomicInteger index = new AtomicInteger(this.size() - 1);
        return this.foldRight(PList.nil(), (r, el) -> r.cons(Pair.of(el, index.getAndDecrement())));
    }

    public String toString() {
        return "[" + this.foldLeft("", (r, e) -> r.isEmpty() ? e + "" : r + ", " + e) + "]";
    }

    public int hashCode() {
        return this.foldLeft(0, (n, e) -> n + 31 * e.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PList other = (PList)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (Pair p : this.zipLazy(other)) {
            if (Objects.equals(p.first(), p.second())) continue;
            return false;
        }
        return true;
    }

    public static final class Nil
    extends PList<Object> {
        private static final PList<Object> INSTANCE = new Nil();

        private Nil() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public PList<Object> tail() {
            throw new NoSuchElementException("tail of empty list");
        }

        @Override
        public Object head() {
            throw new NoSuchElementException("head of empty list");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public PList<Object> reverse() {
            return this;
        }

        @Override
        public <B> PList<B> map(Function<Object, B> f) {
            return this;
        }

        @Override
        public <B> PList<B> flatMap(Function<Object, Iterable<B>> f) {
            return this;
        }

        @Override
        public PList<Object> concat(PList<Object> next) {
            return next;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) || obj instanceof Nil;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class Cons<A>
    extends PList<A> {
        private final A head;
        private final PList<A> tail;
        private final int size;

        private Cons(A head, PList<A> tail, int size) {
            this.head = head;
            this.tail = tail;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public PList<A> tail() {
            return this.tail;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cons cons = (Cons)o;
            return Objects.equals(this.head, cons.head) && Objects.equals(this.tail, cons.tail);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.head, this.tail);
        }
    }
}

