/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.instantiation;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.pojobuilder.Mapper;
import io.github.muehmar.pojobuilder.generator.impl.gen.instantiation.FieldVariable;
import io.github.muehmar.pojobuilder.generator.impl.gen.instantiation.FinalConstructorArgument;
import io.github.muehmar.pojobuilder.generator.model.MatchingConstructor;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.Objects;

public class ConstructorCallGens {
    private ConstructorCallGens() {
    }

    public static Generator<Pojo, PojoSettings> callWithAllLocalVariables(String prefix) {
        return Generator.emptyGen().append(ConstructorCallGens.constructorCallForFields(prefix), pojo -> {
            MatchingConstructor matchingConstructor = pojo.getMatchingConstructorOrThrow();
            PList<FinalConstructorArgument> fields = matchingConstructor.getFieldArguments().map(fa -> FinalConstructorArgument.ofFieldVariable(new FieldVariable((Pojo)pojo, fa.getField(), OptionalFieldRelation.SAME_TYPE), fa));
            return new ConstructorCall((Pojo)pojo, fields, matchingConstructor);
        });
    }

    private static Generator<ConstructorCall, PojoSettings> constructorCallForFields(String prefix) {
        return (constructorCall, settings, writer) -> {
            PList<String> constructorParameters = constructorCall.getFields().map(finalConstructorArgument -> finalConstructorArgument.getRelation().apply(finalConstructorArgument, ConstructorCallGens.onUnwrapOptional(), ConstructorCallGens.onSameType(), ConstructorCallGens.onWrapOptional()));
            boolean hasWrapIntoOptional = constructorCall.getFields().map(FinalConstructorArgument::getRelation).exists(relation -> relation.equals((Object)OptionalFieldRelation.WRAP_INTO_OPTIONAL));
            return Mapper.initial(writer).mapConditionally(hasWrapIntoOptional, w -> w.ref("java.util.Optional")).apply().println("%snew %s%s(%s);", new Object[]{prefix, constructorCall.getPojo().getName(), constructorCall.getPojo().getDiamond(), constructorParameters.mkString(", ")});
        };
    }

    private static OptionalFieldRelation.OnUnwrapOptional<FinalConstructorArgument, String> onUnwrapOptional() {
        return finalConstructorArgument -> String.format("%s.orElse(null)", finalConstructorArgument.getFieldString());
    }

    private static OptionalFieldRelation.OnSameType<FinalConstructorArgument, String> onSameType() {
        return FinalConstructorArgument::getFieldString;
    }

    private static OptionalFieldRelation.OnWrapOptional<FinalConstructorArgument, String> onWrapOptional() {
        return finalConstructorArgument -> String.format("Optional.ofNullable(%s)", finalConstructorArgument.getFieldString());
    }

    private static class ConstructorCall {
        private final Pojo pojo;
        private final PList<FinalConstructorArgument> fields;
        private final MatchingConstructor constructor;

        public ConstructorCall(Pojo pojo, PList<FinalConstructorArgument> fields, MatchingConstructor constructor) {
            this.pojo = pojo;
            this.fields = fields;
            this.constructor = constructor;
        }

        public Pojo getPojo() {
            return this.pojo;
        }

        public PList<FinalConstructorArgument> getFields() {
            return this.fields;
        }

        public MatchingConstructor getMatchingConstructor() {
            return this.constructor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorCall that = (ConstructorCall)o;
            return Objects.equals(this.pojo, that.pojo) && Objects.equals(this.fields, that.fields) && Objects.equals(this.constructor, that.constructor);
        }

        public int hashCode() {
            return Objects.hash(this.pojo, this.fields, this.constructor);
        }

        public String toString() {
            return "ConstructorCall{pojo=" + this.pojo + ", fields=" + this.fields + ", constructor=" + this.constructor + '}';
        }
    }
}

