/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.instantiation;

import io.github.muehmar.pojobuilder.generator.impl.gen.instantiation.FieldVariable;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import java.util.Objects;

class FinalConstructorArgument {
    private final String fieldString;
    private final OptionalFieldRelation relation;

    public FinalConstructorArgument(String fieldString, OptionalFieldRelation relation) {
        this.fieldString = fieldString;
        this.relation = relation;
    }

    public static FinalConstructorArgument ofFieldVariable(FieldVariable fieldVariable, FieldArgument fieldArgument) {
        return new FinalConstructorArgument(fieldVariable.getField().getName().asString(), fieldVariable.getRelation().andThen(fieldArgument.getRelation()));
    }

    public String getFieldString() {
        return this.fieldString;
    }

    public OptionalFieldRelation getRelation() {
        return this.relation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalConstructorArgument finalConstructorArgument = (FinalConstructorArgument)o;
        return Objects.equals(this.fieldString, finalConstructorArgument.fieldString) && this.relation == finalConstructorArgument.relation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldString, this.relation});
    }

    public String toString() {
        return "Field{fieldString='" + this.fieldString + '\'' + ", relation=" + (Object)((Object)this.relation) + '}';
    }
}

