/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder;

import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.codegenerator.java.ConstructorGen;
import io.github.muehmar.codegenerator.java.JavaGenerators;
import io.github.muehmar.codegenerator.java.JavaModifier;
import io.github.muehmar.codegenerator.writer.Writer;
import io.github.muehmar.pojobuilder.generator.impl.gen.Generators;
import io.github.muehmar.pojobuilder.generator.impl.gen.RefsGen;
import io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model.BuilderField;
import io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model.BuilderFieldWithMethod;
import io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model.IndexedField;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class SafeBuilderGens {
    private static final String BUILDER_ASSIGNMENT = "this.builder = builder;";

    private SafeBuilderGens() {
    }

    public static Generator<BuilderField, PojoSettings> fieldBuilderClass() {
        return JavaGenerators.classGen().clazz().nested().packageGen(Generator.emptyGen()).modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC, JavaModifier.FINAL).className(f -> SafeBuilderGens.classDeclaration(f.getIndexedField())).noSuperClass().noInterfaces().content(SafeBuilderGens.builderClassContent()).build().append(RefsGen.genericRefs(), BuilderField::getPojo);
    }

    private static String rawClassName(IndexedField field) {
        String prefix = field.getField().isRequired() ? "" : "Opt";
        return String.format("%sBuilder%d", prefix, field.getIndex());
    }

    private static String classDeclaration(IndexedField field) {
        return SafeBuilderGens.rawClassName(field) + field.getPojo().getGenericTypeDeclarationSection();
    }

    private static String nextClassTypeVariables(IndexedField field) {
        return SafeBuilderGens.nextRawClassName(field) + field.getPojo().getTypeVariablesSection();
    }

    private static String nextClassDiamond(IndexedField field) {
        return SafeBuilderGens.nextRawClassName(field) + field.getPojo().getDiamond();
    }

    private static String nextRawClassName(IndexedField field) {
        return SafeBuilderGens.rawClassName(field.withIndex(field.getIndex() + 1));
    }

    public static Generator<BuilderField, PojoSettings> builderClassContent() {
        return SafeBuilderGens.fieldDeclaration().contraMap(BuilderField::getPojo).append(Generators.newLine()).append(SafeBuilderGens.constructor()).append(Generators.newLine()).append(SafeBuilderGens.setMethod()).appendConditionally(BuilderField::hasFieldBuilder, SafeBuilderGens.fieldBuilderMethods().prependNewLine()).appendConditionally(BuilderField::isFieldOptional, SafeBuilderGens.setMethodOptional().prependNewLine());
    }

    public static <A> Generator<Pojo, A> fieldDeclaration() {
        return (p, s, w) -> w.println("private final Builder%s builder;", new Object[]{p.getTypeVariablesSection()});
    }

    public static Generator<BuilderField, PojoSettings> constructor() {
        return JavaGenerators.constructorGen().modifiers(JavaModifier.PRIVATE).className(f -> SafeBuilderGens.rawClassName(f.getIndexedField())).singleArgument(f -> String.format("Builder%s builder", f.getPojo().getTypeVariablesSection())).content(BUILDER_ASSIGNMENT).build();
    }

    public static <A> Generator<Pojo, A> andAllOptionalsMethod() {
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(p -> "OptBuilder0" + p.getTypeVariablesSection()).methodName("andAllOptionals").noArguments().content(p -> String.format("return new OptBuilder0%s(builder);", p.getDiamond())).build();
    }

    public static <A> Generator<Pojo, A> andOptionalsMethod() {
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(p -> "Builder" + p.getTypeVariablesSection()).methodName("andOptionals").noArguments().content("return builder;").build();
    }

    public static Generator<Pojo, PojoSettings> buildMethod() {
        Function<Pojo, String> createReturnType = p -> p.getBuildMethod().map(BuildMethod::getReturnType).map(Type::getTypeDeclaration).orElseGet(p::getNameWithTypeVariables).asString();
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(createReturnType).methodName("build").noArguments().content("return builder.build();").build();
    }

    public static Generator<BuilderField, PojoSettings> setMethod() {
        Generator content = (f, s, w) -> w.println("return new %s(builder.%s(%s));", new Object[]{SafeBuilderGens.nextClassDiamond(f.getIndexedField()), f.getField().builderSetMethodName((PojoSettings)s), f.getField().getName()});
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(f -> SafeBuilderGens.nextClassTypeVariables(f.getIndexedField())).methodName((f, s) -> f.getField().builderSetMethodName((PojoSettings)s).asString()).singleArgument(f -> String.format("%s %s", f.getField().getType().getTypeDeclaration(), f.getField().getName())).content(content).build().append(RefsGen.fieldRefs(), BuilderField::getField).filter(BuilderField::isEnableDefaultMethods);
    }

    public static Generator<BuilderField, PojoSettings> setMethodOptional() {
        Generator content = (f, s, w) -> w.println("return new %s(builder.%s(%s));", new Object[]{SafeBuilderGens.nextClassDiamond(f.getIndexedField()), f.getField().builderSetMethodName((PojoSettings)s), f.getField().getName()});
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(f -> SafeBuilderGens.nextClassTypeVariables(f.getIndexedField())).methodName((f, s) -> f.getField().builderSetMethodName((PojoSettings)s).asString()).singleArgument(f -> String.format("Optional<%s> %s", f.getField().getType().getTypeDeclaration(), f.getField().getName())).content(content).build().append(w -> w.ref("java.util.Optional")).append(RefsGen.fieldRefs(), BuilderField::getField).filter(BuilderField::isEnableDefaultMethods);
    }

    public static Generator<BuilderField, PojoSettings> fieldBuilderMethods() {
        Generator content = (f, s, w) -> w.println("return new %s(builder.%s(%s%s.%s(%s)));", new Object[]{SafeBuilderGens.nextClassDiamond(f.getIndexedField()), f.getField().builderSetMethodName((PojoSettings)s), f.getPojo().getName(), f.getFieldBuilderMethod().getInnerClassName().map(name -> name.prefix(".").asString()).orElse(""), f.getFieldBuilderMethod().getMethodName(), f.getFieldBuilderMethod().getArgumentNames().mkString(", ")});
        Function<BuilderFieldWithMethod, String> nextClassTypeVariables = f -> SafeBuilderGens.nextClassTypeVariables(f.getIndexedField());
        Generator singleMethod = JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC).noGenericTypes().returnType(nextClassTypeVariables).methodName(f -> f.getFieldBuilderMethod().getMethodName().asString()).arguments(f -> f.getFieldBuilderMethod().getArguments().map(Argument::formatted)).content(content).build().append(RefsGen.fieldBuilderMethodRefs(), BuilderFieldWithMethod::getFieldBuilderMethod);
        return Generator.emptyGen().appendList(singleMethod, BuilderField::getBuilderFieldsWithMethod, Generator.ofWriterFunction(Writer::println));
    }

    public static Generator<Pojo, PojoSettings> finalRequiredBuilder() {
        ToIntFunction<Pojo> builderNumber = pojo -> pojo.getFields().filter(PojoField::isRequired).size();
        ConstructorGen constructor = JavaGenerators.constructorGen().modifiers(JavaModifier.PRIVATE).className(p -> String.format("Builder%d", builderNumber.applyAsInt((Pojo)p))).singleArgument(p -> String.format("Builder%s builder", p.getTypeVariablesSection())).content(BUILDER_ASSIGNMENT).build();
        Generator content = SafeBuilderGens.fieldDeclaration().append(Generators.newLine()).append((Generator)constructor).append(Generators.newLine()).append(SafeBuilderGens.andAllOptionalsMethod()).append(Generators.newLine()).append(SafeBuilderGens.andOptionalsMethod()).append(Generators.newLine()).append(SafeBuilderGens.buildMethod());
        return JavaGenerators.classGen().clazz().nested().packageGen(Generator.emptyGen()).modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC, JavaModifier.FINAL).className((p, s) -> String.format("Builder%d%s", builderNumber.applyAsInt((Pojo)p), p.getGenericTypeDeclarationSection())).noSuperClass().noInterfaces().content(content).build().append(RefsGen.genericRefs());
    }

    public static Generator<Pojo, PojoSettings> finalOptionalBuilder() {
        ToIntFunction<Pojo> builderNumber = pojo -> pojo.getFields().filter(PojoField::isOptional).size();
        ConstructorGen constructor = JavaGenerators.constructorGen().modifiers(JavaModifier.PRIVATE).className(p -> String.format("OptBuilder%d", builderNumber.applyAsInt((Pojo)p))).singleArgument(p -> String.format("Builder%s builder", p.getTypeVariablesSection())).content(BUILDER_ASSIGNMENT).build();
        Generator content = SafeBuilderGens.fieldDeclaration().append(Generators.newLine()).append((Generator)constructor).append(Generators.newLine()).append(SafeBuilderGens.buildMethod());
        return JavaGenerators.classGen().clazz().nested().packageGen(Generator.emptyGen()).modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC, JavaModifier.FINAL).className((p, s) -> String.format("OptBuilder%d%s", builderNumber.applyAsInt((Pojo)p), p.getGenericTypeDeclarationSection())).noSuperClass().noInterfaces().content(content).build().append(RefsGen.genericRefs());
    }
}

