/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model;

import io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model.BuilderField;
import io.github.muehmar.pojobuilder.generator.impl.gen.safebuilder.model.IndexedField;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface BuilderFieldExtension {
    public IndexedField getIndexedField();

    public Optional<FieldBuilder> getFieldBuilder();

    default public BuilderField withIndexedField(IndexedField indexedField) {
        return new BuilderField(indexedField, this.getFieldBuilder());
    }

    default public BuilderField withFieldBuilder(FieldBuilder fieldBuilder) {
        return new BuilderField(this.getIndexedField(), Optional.ofNullable(fieldBuilder));
    }

    default public BuilderField withFieldBuilder(Optional<FieldBuilder> fieldBuilder) {
        return new BuilderField(this.getIndexedField(), fieldBuilder);
    }

    default public FieldBuilder getFieldBuilderOr(FieldBuilder fieldBuilder) {
        return this.getFieldBuilder().orElse(fieldBuilder);
    }

    default public <T> T map(Function<BuilderField, T> f) {
        BuilderField self = new BuilderField(this.getIndexedField(), this.getFieldBuilder());
        return f.apply(self);
    }

    default public BuilderField mapIf(boolean shouldMap, UnaryOperator<BuilderField> f) {
        BuilderField self = new BuilderField(this.getIndexedField(), this.getFieldBuilder());
        return shouldMap ? (BuilderField)f.apply(self) : self;
    }

    default public <T> BuilderField mapIfPresent(Optional<T> value, BiFunction<BuilderField, T, BuilderField> f) {
        BuilderField self = new BuilderField(this.getIndexedField(), this.getFieldBuilder());
        return value.map((? super T v) -> (BuilderField)f.apply(self, v)).orElse(self);
    }
}

