/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import io.github.muehmar.pojobuilder.generator.model.ArgumentExtension;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojoextension.annotations.PojoExtension;
import java.util.Optional;

@PojoExtension
public final class Argument
implements ArgumentExtension {
    private final Name name;
    private final Type type;

    public static Argument of(Name name, Type type) {
        return new Argument(name, type);
    }

    public String formatted() {
        return String.format("%s %s", this.type.getTypeDeclaration(), this.name);
    }

    public Optional<OptionalFieldRelation> getRelationFromField(PojoField field) {
        if (field.isRequired()) {
            return this.type.equals(field.getType()) ? Optional.of(OptionalFieldRelation.SAME_TYPE) : Optional.empty();
        }
        return field.getType().getRelation(this.getType());
    }

    public Argument(Name name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "Argument(name=" + this.getName() + ", type=" + this.getType() + ")";
    }
}

