/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface ArgumentExtension {
    public Name getName();

    public Type getType();

    default public Argument withName(Name name) {
        return new Argument(name, this.getType());
    }

    default public Argument withType(Type type) {
        return new Argument(this.getName(), type);
    }

    default public <T> T map(Function<Argument, T> f) {
        Argument self = new Argument(this.getName(), this.getType());
        return f.apply(self);
    }

    default public Argument mapIf(boolean shouldMap, UnaryOperator<Argument> f) {
        Argument self = new Argument(this.getName(), this.getType());
        return shouldMap ? (Argument)f.apply(self) : self;
    }

    default public <T> Argument mapIfPresent(Optional<T> value, BiFunction<Argument, T, Argument> f) {
        Argument self = new Argument(this.getName(), this.getType());
        return value.map((? super T v) -> (Argument)f.apply(self, v)).orElse(self);
    }
}

