/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilderMethod;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface FieldBuilderMethodExtension {
    public Name getFieldName();

    public Optional<Name> getInnerClassName();

    public Name getMethodName();

    public Type getReturnType();

    public PList<Argument> getArguments();

    default public FieldBuilderMethod withFieldName(Name fieldName) {
        return new FieldBuilderMethod(fieldName, this.getInnerClassName(), this.getMethodName(), this.getReturnType(), this.getArguments());
    }

    default public FieldBuilderMethod withInnerClassName(Name innerClassName) {
        return new FieldBuilderMethod(this.getFieldName(), Optional.ofNullable(innerClassName), this.getMethodName(), this.getReturnType(), this.getArguments());
    }

    default public FieldBuilderMethod withMethodName(Name methodName) {
        return new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), methodName, this.getReturnType(), this.getArguments());
    }

    default public FieldBuilderMethod withReturnType(Type returnType) {
        return new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), this.getMethodName(), returnType, this.getArguments());
    }

    default public FieldBuilderMethod withArguments(PList<Argument> arguments) {
        return new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), this.getMethodName(), this.getReturnType(), arguments);
    }

    default public FieldBuilderMethod withInnerClassName(Optional<Name> innerClassName) {
        return new FieldBuilderMethod(this.getFieldName(), innerClassName, this.getMethodName(), this.getReturnType(), this.getArguments());
    }

    default public Name getInnerClassNameOr(Name innerClassName) {
        return this.getInnerClassName().orElse(innerClassName);
    }

    default public <T> T map(Function<FieldBuilderMethod, T> f) {
        FieldBuilderMethod self = new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), this.getMethodName(), this.getReturnType(), this.getArguments());
        return f.apply(self);
    }

    default public FieldBuilderMethod mapIf(boolean shouldMap, UnaryOperator<FieldBuilderMethod> f) {
        FieldBuilderMethod self = new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), this.getMethodName(), this.getReturnType(), this.getArguments());
        return shouldMap ? (FieldBuilderMethod)f.apply(self) : self;
    }

    default public <T> FieldBuilderMethod mapIfPresent(Optional<T> value, BiFunction<FieldBuilderMethod, T, FieldBuilderMethod> f) {
        FieldBuilderMethod self = new FieldBuilderMethod(this.getFieldName(), this.getInnerClassName(), this.getMethodName(), this.getReturnType(), this.getArguments());
        return value.map((? super T v) -> (FieldBuilderMethod)f.apply(self, v)).orElse(self);
    }
}

