/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.MatchingConstructor;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.PojoAndField;
import io.github.muehmar.pojobuilder.generator.model.PojoExtension;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojoextension.annotations.Getter;
import java.util.Optional;

@io.github.muehmar.pojoextension.annotations.PojoExtension
public final class Pojo
implements PojoExtension {
    private static final PList<Name> LETTERS_AZ = PList.range(65, 91).map((E n) -> Character.toString((char)n.intValue())).map(Name::fromString);
    private final Name name;
    private final PackageName pkg;
    private final PList<PojoField> fields;
    private final PList<Constructor> constructors;
    private final PList<Generic> generics;
    private final PList<FieldBuilder> fieldBuilders;
    private final Optional<BuildMethod> buildMethod;

    @Override
    @Getter(value="pkg")
    public PackageName getPackage() {
        return this.pkg;
    }

    public PList<PojoAndField> getPojoAndFields() {
        return this.fields.map((E f) -> new PojoAndField(this, (PojoField)f));
    }

    public PList<Name> getGenericImports() {
        return this.generics.flatMap(Generic::getUpperBounds).flatMap(Type::getImports);
    }

    public String getDiamond() {
        return this.generics.nonEmpty() ? "<>" : "";
    }

    public PList<String> getGenericTypeDeclarations() {
        return this.generics.map(Generic::getTypeDeclaration).map(Name::asString);
    }

    public String getGenericTypeDeclarationSection() {
        return Strings.surroundIfNotEmpty("<", this.getGenericTypeDeclarations().mkString(", "), ">");
    }

    public String getTypeVariablesSection() {
        return Strings.surroundIfNotEmpty("<", this.generics.map(Generic::getTypeVariable).mkString(", "), ">");
    }

    public Name getNameWithTypeVariables() {
        return this.name.append(this.getTypeVariablesSection());
    }

    public String getTypeVariablesWildcardSection() {
        return Strings.surroundIfNotEmpty("<", this.generics.map((E ignore) -> "?").mkString(", "), ">");
    }

    public Optional<MatchingConstructor> findMatchingConstructor() {
        return this.constructors.flatMapOptional(c -> c.matchFields(this.fields).map((? super T f) -> new MatchingConstructor((Constructor)c, (PList<FieldArgument>)f))).headOption();
    }

    public MatchingConstructor getMatchingConstructorOrThrow() {
        return this.findMatchingConstructor().orElseThrow(() -> new PojoBuilderException(this.noMatchingConstructorMessage()));
    }

    private String noMatchingConstructorMessage() {
        return String.format("No matching constructor found for class/record %s. A constructor should have all the fields as arguments in the order of declaration and matching type, where the actual type of a non-required field can be wrapped into an java.util.Optional. Furthermoreit should be accessible from within the same package, i.e. at least package-private. If a field isinstantiated in the constructor and not part of the arguments, you can annotate it with @Ignore.", this.getName());
    }

    public Name findUnusedTypeVariableName() {
        PList<Name> typeVariableNames = this.generics.map(Generic::getTypeVariable);
        return LETTERS_AZ.filter(n -> Booleans.not(typeVariableNames.exists(n::equals))).headOption().orElseThrow(() -> new IllegalStateException("All single-letter type variables already used for generic class " + this.getName() + "! If this is really a use case and should be supported, please contact the maintainer."));
    }

    public Name findUnusedTypeVariableName(Name preferred) {
        PList<Name> typeVariableNames = this.generics.map(Generic::getTypeVariable);
        return LETTERS_AZ.cons(preferred).filter(n -> Booleans.not(typeVariableNames.exists(n::equals))).headOption().orElseThrow(() -> new IllegalStateException("All single-letter type variables already used for generic class " + this.getName() + "! If this is really a use case and should be supported, please contact the maintainer."));
    }

    public Pojo(Name name, PackageName pkg, PList<PojoField> fields, PList<Constructor> constructors, PList<Generic> generics, PList<FieldBuilder> fieldBuilders, Optional<BuildMethod> buildMethod) {
        this.name = name;
        this.pkg = pkg;
        this.fields = fields;
        this.constructors = constructors;
        this.generics = generics;
        this.fieldBuilders = fieldBuilders;
        this.buildMethod = buildMethod;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    public PackageName getPkg() {
        return this.pkg;
    }

    @Override
    public PList<PojoField> getFields() {
        return this.fields;
    }

    @Override
    public PList<Constructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public PList<Generic> getGenerics() {
        return this.generics;
    }

    @Override
    public PList<FieldBuilder> getFieldBuilders() {
        return this.fieldBuilders;
    }

    @Override
    public Optional<BuildMethod> getBuildMethod() {
        return this.buildMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pojo)) {
            return false;
        }
        Pojo other = (Pojo)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        PackageName this$pkg = this.getPkg();
        PackageName other$pkg = other.getPkg();
        if (this$pkg == null ? other$pkg != null : !((Object)this$pkg).equals(other$pkg)) {
            return false;
        }
        PList<PojoField> this$fields = this.getFields();
        PList<PojoField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        PList<Constructor> this$constructors = this.getConstructors();
        PList<Constructor> other$constructors = other.getConstructors();
        if (this$constructors == null ? other$constructors != null : !((Object)this$constructors).equals(other$constructors)) {
            return false;
        }
        PList<Generic> this$generics = this.getGenerics();
        PList<Generic> other$generics = other.getGenerics();
        if (this$generics == null ? other$generics != null : !((Object)this$generics).equals(other$generics)) {
            return false;
        }
        PList<FieldBuilder> this$fieldBuilders = this.getFieldBuilders();
        PList<FieldBuilder> other$fieldBuilders = other.getFieldBuilders();
        if (this$fieldBuilders == null ? other$fieldBuilders != null : !((Object)this$fieldBuilders).equals(other$fieldBuilders)) {
            return false;
        }
        Optional<BuildMethod> this$buildMethod = this.getBuildMethod();
        Optional<BuildMethod> other$buildMethod = other.getBuildMethod();
        return !(this$buildMethod == null ? other$buildMethod != null : !((Object)this$buildMethod).equals(other$buildMethod));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        PackageName $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : ((Object)$pkg).hashCode());
        PList<PojoField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        PList<Constructor> $constructors = this.getConstructors();
        result = result * 59 + ($constructors == null ? 43 : ((Object)$constructors).hashCode());
        PList<Generic> $generics = this.getGenerics();
        result = result * 59 + ($generics == null ? 43 : ((Object)$generics).hashCode());
        PList<FieldBuilder> $fieldBuilders = this.getFieldBuilders();
        result = result * 59 + ($fieldBuilders == null ? 43 : ((Object)$fieldBuilders).hashCode());
        Optional<BuildMethod> $buildMethod = this.getBuildMethod();
        result = result * 59 + ($buildMethod == null ? 43 : ((Object)$buildMethod).hashCode());
        return result;
    }

    public String toString() {
        return "Pojo(name=" + this.getName() + ", pkg=" + this.getPkg() + ", fields=" + this.getFields() + ", constructors=" + this.getConstructors() + ", generics=" + this.getGenerics() + ", fieldBuilders=" + this.getFieldBuilders() + ", buildMethod=" + this.getBuildMethod() + ")";
    }
}

