/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface PojoExtension {
    public Name getName();

    public PackageName getPackage();

    public PList<PojoField> getFields();

    public PList<Constructor> getConstructors();

    public PList<Generic> getGenerics();

    public PList<FieldBuilder> getFieldBuilders();

    public Optional<BuildMethod> getBuildMethod();

    default public Pojo withName(Name name) {
        return new Pojo(name, this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
    }

    default public Pojo withPkg(PackageName pkg) {
        return new Pojo(this.getName(), pkg, this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
    }

    default public Pojo withFields(PList<PojoField> fields) {
        return new Pojo(this.getName(), this.getPackage(), fields, this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
    }

    default public Pojo withConstructors(PList<Constructor> constructors) {
        return new Pojo(this.getName(), this.getPackage(), this.getFields(), constructors, this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
    }

    default public Pojo withGenerics(PList<Generic> generics) {
        return new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), generics, this.getFieldBuilders(), this.getBuildMethod());
    }

    default public Pojo withFieldBuilders(PList<FieldBuilder> fieldBuilders) {
        return new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), fieldBuilders, this.getBuildMethod());
    }

    default public Pojo withBuildMethod(BuildMethod buildMethod) {
        return new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), Optional.ofNullable(buildMethod));
    }

    default public Pojo withBuildMethod(Optional<BuildMethod> buildMethod) {
        return new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), buildMethod);
    }

    default public BuildMethod getBuildMethodOr(BuildMethod buildMethod) {
        return this.getBuildMethod().orElse(buildMethod);
    }

    default public <T> T map(Function<Pojo, T> f) {
        Pojo self = new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
        return f.apply(self);
    }

    default public Pojo mapIf(boolean shouldMap, UnaryOperator<Pojo> f) {
        Pojo self = new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
        return shouldMap ? (Pojo)f.apply(self) : self;
    }

    default public <T> Pojo mapIfPresent(Optional<T> value, BiFunction<Pojo, T, Pojo> f) {
        Pojo self = new Pojo(this.getName(), this.getPackage(), this.getFields(), this.getConstructors(), this.getGenerics(), this.getFieldBuilders(), this.getBuildMethod());
        return value.map((? super T v) -> (Pojo)f.apply(self, v)).orElse(self);
    }
}

