/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilderMethod;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Necessity;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import io.github.muehmar.pojobuilder.generator.model.PojoFieldExtension;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojoextension.annotations.PojoExtension;
import java.util.Optional;
import java.util.function.Predicate;

@PojoExtension
public final class PojoField
implements PojoFieldExtension {
    private final Name name;
    private final Type type;
    private final Necessity necessity;

    public boolean isRequired() {
        return this.necessity.isRequired();
    }

    public boolean isOptional() {
        return this.necessity.isOptional();
    }

    public Name builderSetMethodName(PojoSettings settings) {
        return settings.getBuilderSetMethodPrefix().map((? super T prefix) -> prefix.append(this.name.toPascalCase())).orElse(this.name);
    }

    public boolean isFieldBuilder(Name pojoName, FieldBuilder fieldBuilder) {
        boolean fieldNameMatches = fieldBuilder.getFieldName().equals(this.name);
        if (Booleans.not(fieldNameMatches)) {
            return false;
        }
        return fieldBuilder.getMethods().toPList().forall(method -> this.isFieldBuilderMethod(pojoName, (FieldBuilderMethod)method));
    }

    public boolean isFieldBuilderMethod(Name pojoName, FieldBuilderMethod method) {
        boolean fieldNameMatches = method.getFieldName().equals(this.name);
        if (Booleans.not(fieldNameMatches)) {
            return false;
        }
        return this.necessity.onRequired(() -> this.assertRequiredType(pojoName, method)).onOptional(() -> this.assertOptionalType(pojoName, method));
    }

    private boolean assertRequiredType(Name pojoName, FieldBuilderMethod method) {
        boolean sameType = method.getReturnType().equals(this.type);
        if (Booleans.not(sameType)) {
            String message = this.formatErrorMessage(pojoName, method);
            throw new PojoBuilderException(message);
        }
        return true;
    }

    private boolean assertOptionalType(Name pojoName, FieldBuilderMethod method) {
        Predicate<OptionalFieldRelation> sameTypeOrUnwrapOptional;
        Optional<OptionalFieldRelation> typeRelation = method.getReturnType().getRelation(this.type);
        boolean optionalTypeMatches = typeRelation.filter(sameTypeOrUnwrapOptional = r -> r.equals((Object)OptionalFieldRelation.SAME_TYPE) || r.equals((Object)OptionalFieldRelation.UNWRAP_OPTIONAL)).isPresent();
        if (Booleans.not(optionalTypeMatches)) {
            String message = this.formatErrorMessage(pojoName, method) + " As this field is optional, the actual type could also be wrapped into a java.util.Optional.";
            throw new PojoBuilderException(message);
        }
        return true;
    }

    private String formatErrorMessage(Name pojoName, FieldBuilderMethod method) {
        String innerClassNameMessage = method.getInnerClassName().map((? super T innerClassName) -> String.format("(in class %s) ", innerClassName)).orElse("");
        return String.format("The return type '%s' of the method '%s' %sannotated with @FieldBuilder for field '%s' of '%s' does not match the type '%s' of the field '%s'.", method.getReturnType().getName(), method.getMethodName(), innerClassNameMessage, this.name, pojoName, this.type.getName(), this.name);
    }

    public PojoField(Name name, Type type, Necessity necessity) {
        this.name = name;
        this.type = type;
        this.necessity = necessity;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Necessity getNecessity() {
        return this.necessity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoField)) {
            return false;
        }
        PojoField other = (PojoField)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Necessity this$necessity = this.getNecessity();
        Necessity other$necessity = other.getNecessity();
        return !(this$necessity == null ? other$necessity != null : !((Object)((Object)this$necessity)).equals((Object)other$necessity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Necessity $necessity = this.getNecessity();
        result = result * 59 + ($necessity == null ? 43 : ((Object)((Object)$necessity)).hashCode());
        return result;
    }

    public String toString() {
        return "PojoField(name=" + this.getName() + ", type=" + this.getType() + ", necessity=" + (Object)((Object)this.getNecessity()) + ")";
    }
}

