/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Necessity;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface PojoFieldExtension {
    public Name getName();

    public Type getType();

    public Necessity getNecessity();

    default public PojoField withName(Name name) {
        return new PojoField(name, this.getType(), this.getNecessity());
    }

    default public PojoField withType(Type type) {
        return new PojoField(this.getName(), type, this.getNecessity());
    }

    default public PojoField withNecessity(Necessity necessity) {
        return new PojoField(this.getName(), this.getType(), necessity);
    }

    default public <T> T map(Function<PojoField, T> f) {
        PojoField self = new PojoField(this.getName(), this.getType(), this.getNecessity());
        return f.apply(self);
    }

    default public PojoField mapIf(boolean shouldMap, UnaryOperator<PojoField> f) {
        PojoField self = new PojoField(this.getName(), this.getType(), this.getNecessity());
        return shouldMap ? (PojoField)f.apply(self) : self;
    }

    default public <T> PojoField mapIfPresent(Optional<T> value, BiFunction<PojoField, T, PojoField> f) {
        PojoField self = new PojoField(this.getName(), this.getType(), this.getNecessity());
        return value.map((? super T v) -> (PojoField)f.apply(self, v)).orElse(self);
    }
}

