/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.settings;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import io.github.muehmar.pojobuilder.generator.model.ClassAccessLevelModifier;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettingsBuilder;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettingsExtension;
import io.github.muehmar.pojoextension.annotations.PojoExtension;
import java.util.Optional;

@PojoExtension
public final class PojoSettings
implements PojoSettingsExtension {
    private static final Name CLASS_NAME_PLACEHOLDER = Name.fromString("{CLASSNAME}");
    public static final Name BUILDER_CLASS_POSTFIX = Name.fromString("Builder");
    private final PList<OptionalDetection> optionalDetections;
    private final Optional<Name> builderName;
    private final Optional<Name> builderSetMethodPrefix;
    private final ClassAccessLevelModifier builderAccessLevel;

    public static PojoSettings defaultSettings() {
        return PojoSettingsBuilder.create().optionalDetections(PList.of(OptionalDetection.OPTIONAL_CLASS, OptionalDetection.NULLABLE_ANNOTATION)).builderAccessLevel(ClassAccessLevelModifier.PUBLIC).andAllOptionals().builderName(Optional.of(CLASS_NAME_PLACEHOLDER.append(BUILDER_CLASS_POSTFIX))).builderSetMethodPrefix(Optional.empty()).build();
    }

    public Name qualifiedBuilderName(Pojo pojo) {
        return pojo.getPackage().qualifiedName(this.builderName(pojo));
    }

    public Name builderName(Pojo pojo) {
        return this.getNameOrAppend(this.builderName, BUILDER_CLASS_POSTFIX, pojo);
    }

    private Name getNameOrAppend(Optional<Name> name, Name postfix, Pojo pojo) {
        return name.map((? super T n) -> n.replace(CLASS_NAME_PLACEHOLDER, this.getClassName(pojo))).orElseGet(() -> this.getClassName(pojo).append(postfix));
    }

    private Name getClassName(Pojo pojo) {
        return pojo.getName().map(n -> n.replace(".", ""));
    }

    public PojoSettings(PList<OptionalDetection> optionalDetections, Optional<Name> builderName, Optional<Name> builderSetMethodPrefix, ClassAccessLevelModifier builderAccessLevel) {
        this.optionalDetections = optionalDetections;
        this.builderName = builderName;
        this.builderSetMethodPrefix = builderSetMethodPrefix;
        this.builderAccessLevel = builderAccessLevel;
    }

    @Override
    public PList<OptionalDetection> getOptionalDetections() {
        return this.optionalDetections;
    }

    @Override
    public Optional<Name> getBuilderName() {
        return this.builderName;
    }

    @Override
    public Optional<Name> getBuilderSetMethodPrefix() {
        return this.builderSetMethodPrefix;
    }

    @Override
    public ClassAccessLevelModifier getBuilderAccessLevel() {
        return this.builderAccessLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoSettings)) {
            return false;
        }
        PojoSettings other = (PojoSettings)o;
        PList<OptionalDetection> this$optionalDetections = this.getOptionalDetections();
        PList<OptionalDetection> other$optionalDetections = other.getOptionalDetections();
        if (this$optionalDetections == null ? other$optionalDetections != null : !((Object)this$optionalDetections).equals(other$optionalDetections)) {
            return false;
        }
        Optional<Name> this$builderName = this.getBuilderName();
        Optional<Name> other$builderName = other.getBuilderName();
        if (this$builderName == null ? other$builderName != null : !((Object)this$builderName).equals(other$builderName)) {
            return false;
        }
        Optional<Name> this$builderSetMethodPrefix = this.getBuilderSetMethodPrefix();
        Optional<Name> other$builderSetMethodPrefix = other.getBuilderSetMethodPrefix();
        if (this$builderSetMethodPrefix == null ? other$builderSetMethodPrefix != null : !((Object)this$builderSetMethodPrefix).equals(other$builderSetMethodPrefix)) {
            return false;
        }
        ClassAccessLevelModifier this$builderAccessLevel = this.getBuilderAccessLevel();
        ClassAccessLevelModifier other$builderAccessLevel = other.getBuilderAccessLevel();
        return !(this$builderAccessLevel == null ? other$builderAccessLevel != null : !((Object)((Object)this$builderAccessLevel)).equals((Object)other$builderAccessLevel));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PList<OptionalDetection> $optionalDetections = this.getOptionalDetections();
        result = result * 59 + ($optionalDetections == null ? 43 : ((Object)$optionalDetections).hashCode());
        Optional<Name> $builderName = this.getBuilderName();
        result = result * 59 + ($builderName == null ? 43 : ((Object)$builderName).hashCode());
        Optional<Name> $builderSetMethodPrefix = this.getBuilderSetMethodPrefix();
        result = result * 59 + ($builderSetMethodPrefix == null ? 43 : ((Object)$builderSetMethodPrefix).hashCode());
        ClassAccessLevelModifier $builderAccessLevel = this.getBuilderAccessLevel();
        result = result * 59 + ($builderAccessLevel == null ? 43 : ((Object)((Object)$builderAccessLevel)).hashCode());
        return result;
    }

    public String toString() {
        return "PojoSettings(optionalDetections=" + this.getOptionalDetections() + ", builderName=" + this.getBuilderName() + ", builderSetMethodPrefix=" + this.getBuilderSetMethodPrefix() + ", builderAccessLevel=" + (Object)((Object)this.getBuilderAccessLevel()) + ")";
    }
}

