/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.settings;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import io.github.muehmar.pojobuilder.generator.model.ClassAccessLevelModifier;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface PojoSettingsExtension {
    public PList<OptionalDetection> getOptionalDetections();

    public Optional<Name> getBuilderName();

    public Optional<Name> getBuilderSetMethodPrefix();

    public ClassAccessLevelModifier getBuilderAccessLevel();

    default public PojoSettings withOptionalDetections(PList<OptionalDetection> optionalDetections) {
        return new PojoSettings(optionalDetections, this.getBuilderName(), this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
    }

    default public PojoSettings withBuilderName(Name builderName) {
        return new PojoSettings(this.getOptionalDetections(), Optional.ofNullable(builderName), this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
    }

    default public PojoSettings withBuilderSetMethodPrefix(Name builderSetMethodPrefix) {
        return new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), Optional.ofNullable(builderSetMethodPrefix), this.getBuilderAccessLevel());
    }

    default public PojoSettings withBuilderAccessLevel(ClassAccessLevelModifier builderAccessLevel) {
        return new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), this.getBuilderSetMethodPrefix(), builderAccessLevel);
    }

    default public PojoSettings withBuilderName(Optional<Name> builderName) {
        return new PojoSettings(this.getOptionalDetections(), builderName, this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
    }

    default public PojoSettings withBuilderSetMethodPrefix(Optional<Name> builderSetMethodPrefix) {
        return new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), builderSetMethodPrefix, this.getBuilderAccessLevel());
    }

    default public Name getBuilderNameOr(Name builderName) {
        return this.getBuilderName().orElse(builderName);
    }

    default public Name getBuilderSetMethodPrefixOr(Name builderSetMethodPrefix) {
        return this.getBuilderSetMethodPrefix().orElse(builderSetMethodPrefix);
    }

    default public <T> T map(Function<PojoSettings, T> f) {
        PojoSettings self = new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
        return f.apply(self);
    }

    default public PojoSettings mapIf(boolean shouldMap, UnaryOperator<PojoSettings> f) {
        PojoSettings self = new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
        return shouldMap ? (PojoSettings)f.apply(self) : self;
    }

    default public <T> PojoSettings mapIfPresent(Optional<T> value, BiFunction<PojoSettings, T, PojoSettings> f) {
        PojoSettings self = new PojoSettings(this.getOptionalDetections(), this.getBuilderName(), this.getBuilderSetMethodPrefix(), this.getBuilderAccessLevel());
        return value.map((? super T v) -> (PojoSettings)f.apply(self, v)).orElse(self);
    }
}

