/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.ArrayTypeExtension;
import io.github.muehmar.pojobuilder.generator.model.type.SpecificType;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.generator.model.type.TypeKind;
import io.github.muehmar.pojoextension.annotations.PojoExtension;

@PojoExtension
public final class ArrayType
implements ArrayTypeExtension,
SpecificType {
    private final Type itemType;
    private final boolean isVarargs;

    public static ArrayType fromItemType(Type itemType) {
        return new ArrayType(itemType, false);
    }

    public static ArrayType varargs(Type itemType) {
        return new ArrayType(itemType, true);
    }

    @Override
    public Name getName() {
        return this.getTypeDeclaration();
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public Name getTypeDeclaration() {
        String suffix = this.isVarargs ? "..." : "[]";
        return this.itemType.getTypeDeclaration().append(suffix);
    }

    @Override
    public PList<Name> getImports() {
        return this.itemType.getImports();
    }

    public ArrayType(Type itemType, boolean isVarargs) {
        this.itemType = itemType;
        this.isVarargs = isVarargs;
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public boolean isVarargs() {
        return this.isVarargs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        if (this.isVarargs() != other.isVarargs()) {
            return false;
        }
        Type this$itemType = this.getItemType();
        Type other$itemType = other.getItemType();
        return !(this$itemType == null ? other$itemType != null : !((Object)this$itemType).equals(other$itemType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVarargs() ? 79 : 97);
        Type $itemType = this.getItemType();
        result = result * 59 + ($itemType == null ? 43 : ((Object)$itemType).hashCode());
        return result;
    }

    public String toString() {
        return "ArrayType(itemType=" + this.getItemType() + ", isVarargs=" + this.isVarargs() + ")";
    }
}

