/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import io.github.muehmar.pojobuilder.generator.model.type.ArrayType;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

interface ArrayTypeExtension {
    public Type getItemType();

    public boolean isVarargs();

    default public ArrayType withItemType(Type itemType) {
        return new ArrayType(itemType, this.isVarargs());
    }

    default public ArrayType withIsVarargs(boolean isVarargs) {
        return new ArrayType(this.getItemType(), isVarargs);
    }

    default public <T> T map(Function<ArrayType, T> f) {
        ArrayType self = new ArrayType(this.getItemType(), this.isVarargs());
        return f.apply(self);
    }

    default public ArrayType mapIf(boolean shouldMap, UnaryOperator<ArrayType> f) {
        ArrayType self = new ArrayType(this.getItemType(), this.isVarargs());
        return shouldMap ? (ArrayType)f.apply(self) : self;
    }

    default public <T> ArrayType mapIfPresent(Optional<T> value, BiFunction<ArrayType, T, ArrayType> f) {
        ArrayType self = new ArrayType(this.getItemType(), this.isVarargs());
        return value.map((? super T v) -> (ArrayType)f.apply(self, v)).orElse(self);
    }
}

