/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.type.Classname;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassnameParser {
    private static final String PACKAGE_NAME_PATTERN = "[a-z][A-Za-z0-9_$]*";
    private static final String IDENTIFIER_PATTERN = "[A-Z][A-Za-z0-9_$]*";
    private static final Pattern QUALIFIED_CLASS_NAME_PATTERN = Pattern.compile(String.format("^(?:(%s(?:\\.%s)*)\\.)?(%s(?:\\.%s)*)", "[a-z][A-Za-z0-9_$]*", "[a-z][A-Za-z0-9_$]*", "[A-Z][A-Za-z0-9_$]*", "[A-Z][A-Za-z0-9_$]*"));

    private ClassnameParser() {
    }

    public static NameAndPackage parseThrowing(String classname) {
        return ClassnameParser.parse(classname).orElseThrow(() -> new IllegalArgumentException("Class " + classname + " cannot be parsed. It must match " + QUALIFIED_CLASS_NAME_PATTERN.pattern()));
    }

    public static Optional<NameAndPackage> parse(String classname) {
        Matcher matcher = QUALIFIED_CLASS_NAME_PATTERN.matcher(classname);
        if (matcher.find()) {
            Classname name = Classname.fromFullClassName(matcher.group(2));
            Optional<PackageName> packageName = Optional.ofNullable(matcher.group(1)).map(PackageName::fromString);
            return Optional.of(new NameAndPackage(name, packageName));
        }
        return Optional.empty();
    }

    public static final class NameAndPackage {
        private final Classname classname;
        private final Optional<PackageName> pkg;

        public NameAndPackage(Classname classname, Optional<PackageName> pkg) {
            this.classname = classname;
            this.pkg = pkg;
        }

        public Classname getClassname() {
            return this.classname;
        }

        public Optional<PackageName> getPkg() {
            return this.pkg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameAndPackage)) {
                return false;
            }
            NameAndPackage other = (NameAndPackage)o;
            Classname this$classname = this.getClassname();
            Classname other$classname = other.getClassname();
            if (this$classname == null ? other$classname != null : !((Object)this$classname).equals(other$classname)) {
                return false;
            }
            Optional<PackageName> this$pkg = this.getPkg();
            Optional<PackageName> other$pkg = other.getPkg();
            return !(this$pkg == null ? other$pkg != null : !((Object)this$pkg).equals(other$pkg));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Classname $classname = this.getClassname();
            result = result * 59 + ($classname == null ? 43 : ((Object)$classname).hashCode());
            Optional<PackageName> $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : ((Object)$pkg).hashCode());
            return result;
        }

        public String toString() {
            return "ClassnameParser.NameAndPackage(classname=" + this.getClassname() + ", pkg=" + this.getPkg() + ")";
        }
    }
}

