/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.type.Classname;
import io.github.muehmar.pojobuilder.generator.model.type.DeclaredTypeExtension;
import io.github.muehmar.pojobuilder.generator.model.type.SpecificType;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.generator.model.type.TypeKind;
import io.github.muehmar.pojoextension.annotations.PojoExtension;
import java.util.Optional;

@PojoExtension
public final class DeclaredType
implements DeclaredTypeExtension,
SpecificType {
    private final Classname classname;
    private final Optional<PackageName> pkg;
    private final PList<Type> typeParameters;

    public static DeclaredType fromNameAndPackage(Classname name, PackageName packageName) {
        return new DeclaredType(name, Optional.of(packageName), PList.empty());
    }

    public static DeclaredType of(Classname name, PackageName packageName, Type singeTypeParameter) {
        return new DeclaredType(name, Optional.of(packageName), PList.single(singeTypeParameter));
    }

    public static DeclaredType of(Classname name, PackageName packageName, PList<Type> typeParameters) {
        return new DeclaredType(name, Optional.of(packageName), typeParameters);
    }

    public static DeclaredType of(Classname name, Optional<PackageName> packageName, PList<Type> typeParameters) {
        return new DeclaredType(name, packageName, typeParameters);
    }

    public static DeclaredType optional(Type value) {
        return DeclaredType.of(Classname.fromFullClassName("Optional"), PackageName.javaUtil(), value);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    @Override
    public Name getTypeDeclaration() {
        Optional<Name> formattedTypeParameters = this.typeParameters.map(Type::getTypeDeclaration).reduce((s1, s2) -> s1.append(",").append((Name)s2)).map((? super T s) -> s.prefix("<").append(">"));
        return this.classname.asName().append(formattedTypeParameters.map(Name::asString).orElse(""));
    }

    @Override
    public PList<Name> getImports() {
        return PList.fromOptional(this.pkg.map((? super T p) -> this.classname.getOuterClassname().prefix(p + "."))).concat(this.typeParameters.flatMap(Type::getImports));
    }

    @Override
    public Name getName() {
        return this.classname.asName();
    }

    public boolean isOptional() {
        return this.typeParameters.size() == 1 && this.equals(DeclaredType.optional(this.typeParameters.head()));
    }

    public DeclaredType(Classname classname, Optional<PackageName> pkg, PList<Type> typeParameters) {
        this.classname = classname;
        this.pkg = pkg;
        this.typeParameters = typeParameters;
    }

    @Override
    public Classname getClassname() {
        return this.classname;
    }

    @Override
    public Optional<PackageName> getPkg() {
        return this.pkg;
    }

    @Override
    public PList<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeclaredType)) {
            return false;
        }
        DeclaredType other = (DeclaredType)o;
        Classname this$classname = this.getClassname();
        Classname other$classname = other.getClassname();
        if (this$classname == null ? other$classname != null : !((Object)this$classname).equals(other$classname)) {
            return false;
        }
        Optional<PackageName> this$pkg = this.getPkg();
        Optional<PackageName> other$pkg = other.getPkg();
        if (this$pkg == null ? other$pkg != null : !((Object)this$pkg).equals(other$pkg)) {
            return false;
        }
        PList<Type> this$typeParameters = this.getTypeParameters();
        PList<Type> other$typeParameters = other.getTypeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Classname $classname = this.getClassname();
        result = result * 59 + ($classname == null ? 43 : ((Object)$classname).hashCode());
        Optional<PackageName> $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : ((Object)$pkg).hashCode());
        PList<Type> $typeParameters = this.getTypeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
        return result;
    }

    public String toString() {
        return "DeclaredType(classname=" + this.getClassname() + ", pkg=" + this.getPkg() + ", typeParameters=" + this.getTypeParameters() + ")";
    }
}

