/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import io.github.muehmar.pojobuilder.generator.model.type.ArrayType;
import io.github.muehmar.pojobuilder.generator.model.type.DeclaredType;
import io.github.muehmar.pojobuilder.generator.model.type.PrimitiveType;
import io.github.muehmar.pojobuilder.generator.model.type.SpecificType;
import io.github.muehmar.pojobuilder.generator.model.type.TypeExtension;
import io.github.muehmar.pojobuilder.generator.model.type.TypeKind;
import io.github.muehmar.pojobuilder.generator.model.type.TypeVariableType;
import io.github.muehmar.pojobuilder.generator.model.type.Types;
import io.github.muehmar.pojoextension.annotations.PojoExtension;
import java.util.Optional;
import java.util.function.Function;

@PojoExtension
public final class Type
implements TypeExtension {
    private final SpecificType specificType;

    public static Type fromSpecificType(SpecificType specificType) {
        return new Type(specificType);
    }

    public Name getTypeDeclaration() {
        return this.specificType.getTypeDeclaration();
    }

    public PList<Name> getImports() {
        return this.specificType.getImports();
    }

    public Name getName() {
        return this.specificType.getName();
    }

    public boolean isArray() {
        return this.specificType.getKind().equals((Object)TypeKind.ARRAY);
    }

    public boolean isNotArray() {
        return !this.isArray();
    }

    public boolean isPrimitive() {
        return this.specificType.getKind().equals((Object)TypeKind.PRIMITIVE);
    }

    public boolean isVoid() {
        return Types.voidType().equals(this);
    }

    public boolean isOptional() {
        return this.fold(DeclaredType::isOptional, ignore -> false, ignore -> false, ignore -> false);
    }

    public <T> T fold(Function<DeclaredType, T> onDeclaredType, Function<ArrayType, T> onArray, Function<PrimitiveType, T> onPrimitive, Function<TypeVariableType, T> onTypeVariable) {
        if (this.specificType instanceof DeclaredType) {
            return onDeclaredType.apply((DeclaredType)this.specificType);
        }
        if (this.specificType instanceof ArrayType) {
            return onArray.apply((ArrayType)this.specificType);
        }
        if (this.specificType instanceof PrimitiveType) {
            return onPrimitive.apply((PrimitiveType)this.specificType);
        }
        if (this.specificType instanceof TypeVariableType) {
            return onTypeVariable.apply((TypeVariableType)this.specificType);
        }
        throw new IllegalStateException("Specific type " + this.specificType.getClass() + " not handled when folding.");
    }

    public <T> Optional<T> onDeclaredType(Function<DeclaredType, T> onDeclaredType) {
        return this.fold(decType -> Optional.of(onDeclaredType.apply((DeclaredType)decType)), ignore -> Optional.empty(), ignore -> Optional.empty(), ignore -> Optional.empty());
    }

    public <T> Optional<T> onArrayType(Function<ArrayType, T> onArrayType) {
        return this.fold(ignore -> Optional.empty(), arrayType -> Optional.of(onArrayType.apply((ArrayType)arrayType)), ignore -> Optional.empty(), ignore -> Optional.empty());
    }

    public Optional<OptionalFieldRelation> getRelation(Type other) {
        if (this.equals(other)) {
            return Optional.of(OptionalFieldRelation.SAME_TYPE);
        }
        if (this.isOptional() && this.equals(Types.optional(other))) {
            return Optional.of(OptionalFieldRelation.UNWRAP_OPTIONAL);
        }
        if (other.isOptional() && other.equals(Types.optional(this))) {
            return Optional.of(OptionalFieldRelation.WRAP_INTO_OPTIONAL);
        }
        return Optional.empty();
    }

    public Type(SpecificType specificType) {
        this.specificType = specificType;
    }

    @Override
    public SpecificType getSpecificType() {
        return this.specificType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        Type other = (Type)o;
        SpecificType this$specificType = this.getSpecificType();
        SpecificType other$specificType = other.getSpecificType();
        return !(this$specificType == null ? other$specificType != null : !this$specificType.equals(other$specificType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpecificType $specificType = this.getSpecificType();
        result = result * 59 + ($specificType == null ? 43 : $specificType.hashCode());
        return result;
    }

    public String toString() {
        return "Type(specificType=" + this.getSpecificType() + ")";
    }
}

