/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.SpecificType;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.generator.model.type.TypeKind;
import io.github.muehmar.pojobuilder.generator.model.type.TypeVariableTypeExtension;
import io.github.muehmar.pojoextension.annotations.PojoExtension;

@PojoExtension
public final class TypeVariableType
implements TypeVariableTypeExtension,
SpecificType {
    private final Name name;
    private final PList<Type> upperBounds;

    public static TypeVariableType ofName(Name name) {
        return new TypeVariableType(name, PList.empty());
    }

    public static TypeVariableType ofNameAndUpperBounds(Name name, PList<Type> upperBounds) {
        return new TypeVariableType(name, upperBounds);
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TYPE_VAR;
    }

    @Override
    public Name getTypeDeclaration() {
        return this.getName();
    }

    @Override
    public PList<Name> getImports() {
        return this.upperBounds.flatMap(Type::getImports);
    }

    public Name getTypeVariableDeclaration() {
        String upperBoundsDeclaration = this.upperBounds.map(Type::getTypeDeclaration).mkString(" & ");
        String generic = Strings.surroundIfNotEmpty(" extends ", upperBoundsDeclaration, "");
        return this.name.append(generic);
    }

    public TypeVariableType(Name name, PList<Type> upperBounds) {
        this.name = name;
        this.upperBounds = upperBounds;
    }

    @Override
    public PList<Type> getUpperBounds() {
        return this.upperBounds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeVariableType)) {
            return false;
        }
        TypeVariableType other = (TypeVariableType)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        PList<Type> this$upperBounds = this.getUpperBounds();
        PList<Type> other$upperBounds = other.getUpperBounds();
        return !(this$upperBounds == null ? other$upperBounds != null : !((Object)this$upperBounds).equals(other$upperBounds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        PList<Type> $upperBounds = this.getUpperBounds();
        result = result * 59 + ($upperBounds == null ? 43 : ((Object)$upperBounds).hashCode());
        return result;
    }

    public String toString() {
        return "TypeVariableType(name=" + this.getName() + ", upperBounds=" + this.getUpperBounds() + ")";
    }
}

