/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Optionals;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;

public class AnnotationMemberExtractor {
    public static final String OPTIONAL_DETECTION = "optionalDetection";
    public static final String EXTENSION_NAME = "extensionName";
    public static final String ENABLE_SAFE_BUILDER = "enableSafeBuilder";
    public static final String PACKAGE_PRIVATE_BUILDER = "packagePrivateBuilder";
    public static final String BUILDER_NAME = "builderName";
    public static final String BUILDER_SET_METHOD_PREFIX = "builderSetMethodPrefix";
    public static final String ENABLE_WITHERS = "enableWithers";
    public static final String ENABLE_OPTIONAL_GETTERS = "enableOptionalGetters";
    public static final String ENABLE_MAPPERS = "enableMappers";

    private AnnotationMemberExtractor() {
    }

    public static Optional<PList<OptionalDetection>> getOptionalDetection(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<PList>(OPTIONAL_DETECTION, v -> PList.fromIter((Iterable)v).flatMapOptional(o -> {
            String s = o.toString();
            int index = s.lastIndexOf(".");
            String name = index >= 0 ? s.substring(index + 1) : s;
            return OptionalDetection.fromString((String)name);
        })));
    }

    public static Optional<String> getExtensionName(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<String>(EXTENSION_NAME, String.class::cast));
    }

    public static Optional<Boolean> getEnableSafeBuilder(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<Boolean>(ENABLE_SAFE_BUILDER, Boolean.class::cast));
    }

    public static Optional<Boolean> getPackagePrivateBuilder(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<Boolean>(PACKAGE_PRIVATE_BUILDER, Boolean.class::cast));
    }

    public static Optional<String> getBuilderName(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<String>(BUILDER_NAME, String.class::cast));
    }

    public static Optional<String> getBuilderSetMethodPrefix(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<String>(BUILDER_SET_METHOD_PREFIX, String.class::cast));
    }

    public static Optional<Boolean> getEnableWithers(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<Boolean>(ENABLE_WITHERS, Boolean.class::cast));
    }

    public static Optional<Boolean> getEnableOptionalGetters(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<Boolean>(ENABLE_OPTIONAL_GETTERS, Boolean.class::cast));
    }

    public static Optional<Boolean> getEnableMappers(AnnotationMirror annotationMirror) {
        return AnnotationMemberExtractor.getMember(annotationMirror, new ExtensionMember<Boolean>(ENABLE_MAPPERS, Boolean.class::cast));
    }

    private static <T> Optional<T> getMember(AnnotationMirror annotationMirror, ExtensionMember<T> extensionMember) {
        Function<AnnotationValue, Optional> mapAnnotationValue = val -> {
            try {
                return Optional.of(extensionMember.map.apply(val.getValue()));
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        };
        Optional explicitValue = PList.fromIter(annotationMirror.getElementValues().entrySet()).find(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString().equals(extensionMember.name)).map(Map.Entry::getValue).flatMap(mapAnnotationValue);
        Supplier defaultValue = () -> PList.fromIter(annotationMirror.getAnnotationType().asElement().getEnclosedElements()).filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).map(ExecutableElement.class::cast).find(e -> e.getSimpleName().toString().equals(extensionMember.name)).map(ExecutableElement::getDefaultValue).flatMap(mapAnnotationValue);
        return Optionals.or(explicitValue, defaultValue);
    }

    private static class ExtensionMember<T> {
        private final String name;
        private final Function<Object, T> map;

        public ExtensionMember(String name, Function<Object, T> map) {
            this.name = name;
            this.map = map;
        }
    }
}

